<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class Wallet extends Model
{
    use HasFactory;
    protected $table = 'wallet';

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Accessor for the 'created_at' attribute
    public function getCreatedAtAttribute($value)
    {
        return Carbon::parse($value)->format('Y-m-d H:i:s');
    }

    // Accessor for the 'updated_at' attribute
    public function getUpdatedAtAttribute($value)
    {
        return Carbon::parse($value)->format('Y-m-d H:i:s');
    }

    public function get_data_table()
    {
        $data = DB::table('wallet')
            ->join('drivers', 'wallet.driver_id', '=', 'drivers.id')
            ->select('wallet.*', 'name', 'email', 'mobile')
            ->orderBy('created_at', 'desc')
            ->get();
        return $data;
    }
    
    public function count_all()
    {
        $count = Wallet::count();
        return $count;
    }
}
