<?php
namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\FcmMessage;
use App\Models\Parcels;

class RideReminderNotification extends Notification implements ShouldQueue
{
    use Queueable;

    protected $ride;

    public function __construct(Parcel $ride)
    {
        $this->ride = $ride;
    }

    public function via($notifiable)
    {
        return ['fcm'];
    }

    public function toFcm($notifiable)
    {
        return (new FcmMessage)
            ->data([
                'ride_id' => $this->ride->id,
                'type' => 'ride_reminder',
            ])
            ->notification([
                'title' => 'Upcoming Ride Reminder',
                'body' => 'Your ride is scheduled in 30 minutes.',
            ])
            ->priority('high');
    }
}

