<?php

namespace App\Services;

use Illuminate\Http\UploadedFile;

class RCUploadService
{
    /**
     * Handle the file upload.
     *
     * @param UploadedFile $file
     * @return string
     */
    public function upload(UploadedFile $file): string
    {
        $filename = time() . '_' . $file->getClientOriginalName();
        $filePath = $file->storeAs('uploads/rc', $filename, 'public');
        return $filePath;
    }
}

