<?php

namespace App\Http\Controllers\Api\Driver;

use App\Http\Controllers\Controller;

use App\Http\Requests\StoreBankDetailRequest;
use App\Services\BankDetailService;
use Illuminate\Http\Request;

class BankDetailController extends Controller
{
    protected $service;
    
    public function __construct(BankDetailService $service)
    {
        $this->service = $service;
    }
    
    public function store(StoreBankDetailRequest $request)
    {
        $driver_obj = $request->input('driver_obj');
        $validated  = $request->validated();
        $validated['driver_id'] = $driver_obj['id'];
       
        $bankDetail = $this->service->saveBankDetails($validated);

        return response()->json(['success' => true, 'message'=>'Save successfully', 'data'=>$bankDetail], 201);
    }

    public function update(StoreBankDetailRequest $request, $id)
    {
        $validated = $request->validated();

        $bankDetail = $this->service->updateBankDetails($id, $validated);

        return response()->json($bankDetail, 200);
    }
 
}


