@extends('admin.layouts.main')
@section('main.container')
<div class="content-body">
    <!-- row -->
    <div class="container-fluid">
        <!-- Row -->
        <div class="row">
            <!-- Column starts -->
            <div class="col-xl-12">
                <div class="card" id="accordion-five">
                    <div class="card-header flex-wrap d-flex justify-content-between px-3">
                        <div>
                            <h4 class="card-title">Passenger</h4>
                            <p class="m-0 subtitle">Note: Please arrange Passenger</p>
                        </div>
                        <ul class="nav nav-tabs dzm-tabs" id="myTab-4" role="tablist">
                            <li class="nav-item" role="presentation">
                                <a href="javascript:void(0)" class="btn btn-primary add_new">Add New</a>
                            </li>
                        </ul>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table id="table" class="display table" style="min-width: 845px">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Mobile</th>
                                        <th>Email</th>
                                        <th>Status</th>
                                        <th>Created</th>
                                        <th>Action</th>
                                    </tr>
                                    <tr>
                                        <td><input type="text" placeholder="Name" size="10" class="input-FW"/></td>
                                        <td><input type="text" placeholder="Mobile" size="10" class="input-FW"/></td>
                                        <td><input type="text" placeholder="Email" size="10" class="input-fw"/></td>
                                        <td><input type="text" placeholder="Status" size="10" class="input-fw"/></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Column ends -->
    </div>
</div>

<!------- MODAL ------->
<div class="modal right fade" id="myModel" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-center modal-xl" style="width:100%;">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Passenger</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form role="form" id="myForm" autocomplete="off" enctype='multipart/form-data' class="parsley-validate" data-validate="parsley">
            <div class="modal-body">
                <div class="row">
                    <div class="col-12">
                        <!--This Part is removed it is only here for my ref -->
                        <div class="row">
                            <div class="col-12">
                                <div class="card mb-0">
                                    <div class="card-header p-1">
                                        <h4 class="card-title">Contact Details</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Name</label>
                                                <input type="text" class="form-control" id="name" name="name" placeholder="Name">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Mobile</label>
                                                <input type="text" class="form-control numeric" id="mobile" name="mobile" placeholder="Mobile" data-parsley-required="true" data-parsley-type="digits" maxlength="10" data-parsley-length="[10, 10]">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Email</label>
                                                <input type="text" class="form-control" id="email" name="email" placeholder="Email" data-parsley-required="true" data-parsley-type="email">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="photo" class="form-label">Photo</label>
                                                <input class="form-control form-control-sm" name="photo" id="photo" type="file">
                                                <img src="" name="photo" height="200px;" width="200px;">
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary save">Save</button>
           </div>
           </form>
        </div>
    </div>
</div>
<script>
$(document).on('change','.select-single',function(e){
    $(this).parsley().validate();
    if ($(this).parsley().isValid()){
        $(this).find('~ .select2-container .select2-selection--single').removeAttr('style');
    }
});

$(function(){
    $('.select-single').select2({
        dropdownParent: $('#myModel')
    });
});

var table;
$( document ).ready(function() {
    dataTable();
});

function dataTable()
{
    var postData = {'name': 'neeraj'};
    table = $('#table').DataTable({
        pageLength:100,
        paging:true,
        select: false,
        ordering: false,
        info: true,         
        lengthChange:false ,
        language: {
            paginate: {
              next: '<i class="fa-solid fa-angle-right"></i>',
              previous: '<i class="fa-solid fa-angle-left"></i>' 
            }
        },
        "ajax": {
            "url": "/<?= $TYPE ?>/passenger/index_ajax_passenger_list",
            "type": "POST",
            data: postData,
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        },
        "initComplete": function(settings, json) {
            //js_switch();
        },
        "columnDefs": [ 
            {
                "className": "custom-btngroup",
                "targets": 3,
                "data": null,
                "render": function ( data, type, row ) {
                    var td = '';
                    if(row.status == 1){
                        td=`
                            <td>
                                <span class="badge light badge-success">
                                    <i class="fa fa-circle text-success me-1"></i>
                                    ${row.status_label}
                                </span>
                            </td>
                        `;
                    }else{
                        td=`
                            <td>
                                <span class="badge light badge-danger">
                                    <i class="fa fa-circle text-danger me-1"></i>
                                    ${row.status_label}
                                </span>
                            </td>
                        `;
                    }
                    return td;
                },
                "defaultContent": ''
            },
            {
                "className": "custom-btngroup",
                "targets": -1,
                "data": null,
                "render": function ( data, type, row ) {
                    var enable_disable = '';
                    if(row.status == 1){
                        enable_disable = `<a class="dropdown-item disable" href="javascript:void(0)">Idle</a>`;
                    }else{
                        enable_disable = `<a class="dropdown-item enable" href="javascript:void(0)">Active</a>`;
                    }
                    enable_disable = '';
                    var jsonString = JSON.stringify(row);
                    var td = `
                           <td>
                               <div class="dropdown ms-auto text-end c-pointer">
                                   <div class="btn-link" data-bs-toggle="dropdown" aria-expanded="false">
                                       <svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                           <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                               <rect x="0" y="0" width="24" height="24"></rect>
                                               <circle fill="#000000" cx="5" cy="12" r="2"></circle>
                                               <circle fill="#000000" cx="12" cy="12" r="2"></circle>
                                               <circle fill="#000000" cx="19" cy="12" r="2"></circle>
                                           </g>
                                       </svg>
                                   </div>
                                   <div class="dropdown-menu dropdown-menu-end" style="" data-object='${jsonString}'>
                                       ${enable_disable}
                                       <a class="dropdown-item edit" href="javascript:void(0)">Edit</a>
                                   </div>
                               </div>
                           </td>
                    `;
                    return td;
                },
                "defaultContent": ''
            },
        ],
        "columns": [
           {data: "name"},
           {data: "mobile"},
           {data: "email"},
           {data: "status"},
           {data: "created_at"},
           {data: "id"},
        ]
    });

   $("#table thead input").on('keyup change', function(e) {
        if (e.keyCode == 13 || e.keyCode == undefined || this.value == '') {
            table
                .column($(this).parent().index() + ':visible')
                .search(this.value)
                .draw();
        }
   });
   $('#table_filter').hide();
}

$(document).on('click','.disable',function(e){
    e.preventDefault();
    var row = $(this).parent().data('object');
    var id = row.id;
    var postData = new FormData()
    postData.append('api', '1');
    postData.append('id', id);
    $.ajax({
        type: 'POST',
        url:  "/<?= $TYPE ?>/client/disable",
        data: postData,
        contentType: false,
        cache: false,
        processData:false,
        beforeSend: function() {
             //$('.as_loader').addClass('show');
        },
        success: function(response){
            if(response.status == '1') {
                table.ajax.reload();
                $.notify(response.message, {type: 'success',align:"center", verticalAlign:"top", close: true});
            }else{
                $.notify(response.message, {type: 'warning',align:"center", verticalAlign:"top", close: true});
            }
            //$('.as_loader').removeClass('show');
        },
        error: function (error) {
            //$('.as_loader').removeClass('show');
        }
    });
});

$(document).on('click','.enable',function(e){
    e.preventDefault();
    var row = $(this).parent().data('object');
    var id = row.id;
    var postData = new FormData()
    postData.append('api', '1');
    postData.append('id', id);
    $.ajax({
        type: 'POST',
        url:  "/<?= $TYPE ?>/client/enable",
        data: postData,
        contentType: false,
        cache: false,
        processData:false,
        beforeSend: function() {
             //$('.as_loader').addClass('show');
        },
        success: function(response){
            if(response.status == '1') {
                table.ajax.reload();
                $.notify(response.message, {type: 'success',align:"center", verticalAlign:"top", close: true});
            }else{
                $.notify(response.message, {type: 'warning',align:"center", verticalAlign:"top", close: true});
            }
            //$('.as_loader').removeClass('show');
        },
        error: function (error) {
            //$('.as_loader').removeClass('show');
        }
    });
});

$(document).on('click','.add_new',function(e){
    e.preventDefault();
    $('.parsley-validate').parsley().destroy(); 
    $('.select2-selection--single').removeAttr('style');
    $('#myForm').find('input[name="id"]').remove();
    $('img[name="photo"]').attr('src', '').hide();
    $('#myForm')[0].reset();
    $('.select-single').trigger('change.select2');
    $('#myModel').modal('toggle');
});

$(document).on('click','.edit',function(e){
    e.preventDefault();
    $('.parsley-validate').parsley().destroy(); 
    $('#myForm').find('input[name="id"]').remove();

    var row = $(this).parent().data('object');
    var id = row.id;
    fillForm(row);
    $('img[name="photo"]').attr('src', '').hide();
    if(row.photo){
        $('img[name="photo"]').attr('src', row.photo).show();
    }
    var cnt = row.no_of_licence;
    var hiddenInput = $('<input>').attr({
      type: 'hidden',
      name: 'id',
      id: 'id',
      value: id
    });
    $('#myForm').append(hiddenInput);
    $('#myModel').modal('toggle');
});

$(document).on('click','.save',function(e){
    e.preventDefault();
    $('.parsley-validate').parsley().validate();
    if ($('.parsley-validate').parsley().isValid()){
        var postData = new FormData()
        postData = getFormValues(postData);
        $.ajax({
            type: 'POST',
            url:  "/<?= $TYPE ?>/passenger/save",
            data: postData,
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            dataTyte: 'json',
            enctype: 'multipart/form-data',
            contentType: false,
            cache: false,
            processData:false,
            beforeSend: function() {
                 //$('.as_loader').addClass('show');
            },
            success: function(response){
                if(response.status == '1') {
                    table.ajax.reload();
                    $('#myModel').modal('toggle');
                    $.notify(response.message, {type: 'success',align:"center", verticalAlign:"top", close: true});
                }else{
                    $.notify(response.message, {type: 'warning',align:"center", verticalAlign:"top", close: true});
                }
                //$('.as_loader').removeClass('show');
            },
            error: function (error) {
                //$('.as_loader').removeClass('show');
            }
        });
    }
});
</script>
@endsection
