<div class="content-body">
    <!-- row -->
    <div class="container-fluid">
        <!-- Row -->
        <div class="row">
            <!-- Column starts -->
            <div class="col-xl-12">
                <div class="card" id="accordion-five">
                    <div class="card-header flex-wrap d-flex justify-content-between px-3">
                        <div>
                            <h4 class="card-title">Client</h4>
                            <p class="m-0 subtitle">Note: Please arrange Client</p>
                        </div>
                        <ul class="nav nav-tabs dzm-tabs" id="myTab-4" role="tablist">
                            <li class="nav-item" role="presentation">
                                <a href="javascript:void(0)" class="btn btn-primary add_new">Add New</a>
                            </li>
                        </ul>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table id="table" class="display table" style="min-width: 845px">
                                <thead>
                                    <tr>
                                        <th>Client Name</th>
                                        <th>Name</th>
                                        <th>Mobile</th>
                                        <th>Email</th>
                                        <th>Status</th>
                                        <th>Created</th>
                                        <th>Action</th>
                                    </tr>
                                    <tr>
                                        <td><input type="text" placeholder="Client" size="10" class="input-FW"/></td>
                                        <td><input type="text" placeholder="Name" size="10" class="input-FW"/></td>
                                        <td><input type="text" placeholder="Mobile" size="10" class="input-FW"/></td>
                                        <td><input type="text" placeholder="Email" size="10" class="input-fw"/></td>
                                        <td><input type="text" placeholder="Status" size="10" class="input-fw"/></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Column ends -->
    </div>
</div>

<!------- MODAL ------->
<div class="modal right fade" id="myModel" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-center modal-xl" style="width:100%;">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Client</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form role="form" id="myForm" autocomplete="off" class="parsley-validate" data-validate="parsley">
            <div class="modal-body">
                <div class="row">
                    <div class="col-12">
                        <!--This Part is removed it is only here for my ref -->
                        <div class="row">
                            <div class="col-12">
                                <div class="card mb-0">
                                    <div class="card-header p-1">
                                        <h4 class="card-title">Client Details</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="mb-3 col-6">
                                                <label for="name" class="form-label mb-2">Client Name</label>
                                                <input type="text" class="form-control" id="client_name" name="client_name" placeholder="Client Name" data-parsley-required="true">
                                            </div>
                                            <div class="mb-3 col-6">
                                                <label for="name" class="form-label mb-2">Company Name</label>
                                                <input type="text" class="form-control" id="company_name" name="company_name" placeholder="Company Name" data-parsley-required="true">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Company Type</label>
                                                <input type="text" class="form-control" id="company_type" name="company_type" placeholder="Company Type" data-parsley-required="true">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">GST</label>
                                                <input type="text" class="form-control" id="gst_number" name="gst_number" placeholder="GST" data-parsley-required="true">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">TDS</label>
                                                <input type="text" class="form-control unsigned_float" id="tds" name="tds" placeholder="TDS" data-parsley-required="true">
                                            </div>                            
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Payment Mode</label>
                                                <input type="text" class="form-control" id="payment_mode" name="payment_mode" placeholder="Payment Mode" data-parsley-required="true">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Payment Circle From</label>
                                                <input type="text" class="form-control numeric" id="payment_circle_from" name="payment_circle_from" placeholder="Payment Circle From" data-parsley-required="true">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Payment Circle In Days</label>
                                                <input type="text" class="form-control numeric" id="payment_circle_in_days" name="payment_circle_in_days" placeholder="Payment Circle In Days" data-parsley-required="true">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Poc</label>
                                                <select class="select-single form-control wide mb-3" id="poc" name="poc" data-placeholder="POC" data-parsley-required="true" data-parsley-errors-container="#poc_error">
                                                    <option></option>
                                                    <?php if($poc){ foreach($poc as $s){ ?>
                                                    <option value="<?=$s->poc_id?>"><?=$s->poc_name?></option>
                                                    <?php }} ?>
                                                </select>
                                                <div id="poc_error"></div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-12">
                                <div class="card mb-0">
                                    <div class="card-header p-1">
                                        <h4 class="card-title">Contact Details</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Contact Person</label>
                                                <input type="text" class="form-control" id="contact_person" name="contact_person" placeholder="Contact Person" data-parsley-required="true">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Contact Person Mobile</label>
                                                <input type="text" class="form-control numeric" id="contact_person_mobile" name="contact_person_mobile" placeholder="Contact Person Mobile" data-parsley-required="true" data-parsley-type="digits" maxlength="10" data-parsley-length="[10, 10]">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Contact Person Email</label>
                                                <input type="text" class="form-control" id="contact_person_email" name="contact_person_email" placeholder="Contact Person Email" data-parsley-required="true" data-parsley-type="email">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">City</label>
                                                <input type="text" class="form-control" id="city" name="city" placeholder="City" data-parsley-required="true">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">State</label>
                                                <select class="select-single form-control wide mb-3" id="state" name="state" data-placeholder="State" data-parsley-required="true" data-parsley-errors-container="#state_error">
                                                    <option></option>
                                                    <?php if($states){ foreach($states as $s){ ?>
                                                    <option value="<?=$s->state_id?>"><?=$s->name?></option>
                                                    <?php }} ?>
                                                </select>
                                                <div id="state_error"></div>
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Pincode</label>
                                                <input type="text" class="form-control numeric" id="pincode" name="pincode" placeholder="Pincode" data-parsley-required="true">
                                            </div>
                                            <div class="mb-3 col-12">
                                                <label for="amount" class="form-label mb-2">Company Address</label>
                                                <textarea  class="form-control" id="company_address" name="company_address" placeholder="Company Address" rows="4" cols="50"></textarea>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary save">Save</button>
           </div>
           </form>
        </div>
    </div>
</div>
<script>
$(document).on('change','.select-single',function(e){
    $(this).parsley().validate();
    if ($(this).parsley().isValid()){
        $(this).find('~ .select2-container .select2-selection--single').removeAttr('style');
    }
});

$(function(){
    $('.select-single').select2({
        dropdownParent: $('#myModel')
    });
});

var table;
$( document ).ready(function() {
    dataTable();
});

function dataTable()
{
    var postData = {"<?= $csrf->name;?>" : "<?= $csrf->hash; ?>"};
    table = $('#table').DataTable({
        pageLength:<?= $page_count ?>,
        paging:true,
        select: false,
        ordering: false,
        info: true,         
        lengthChange:false ,
        language: {
            paginate: {
              next: '<i class="fa-solid fa-angle-right"></i>',
              previous: '<i class="fa-solid fa-angle-left"></i>' 
            }
        },
        "ajax": {
            "url": "/<?= $TYPE ?>/client/index_ajax_client_list",
            "type": "POST",
            data: postData,
        },
        "initComplete": function(settings, json) {
            //js_switch();
        },
        "columnDefs": [ 
            {
                "className": "custom-btngroup",
                "targets": 4,
                "data": null,
                "render": function ( data, type, row ) {
                    var td = '';
                    if(row.status == 1){
                        td=`
                            <td>
                                <span class="badge light badge-success">
                                    <i class="fa fa-circle text-success me-1"></i>
                                    ${row.status_label}
                                </span>
                            </td>
                        `;
                    }else{
                        td=`
                            <td>
                                <span class="badge light badge-danger">
                                    <i class="fa fa-circle text-danger me-1"></i>
                                    ${row.status_label}
                                </span>
                            </td>
                        `;
                    }
                    return td;
                },
                "defaultContent": ''
            },
            {
                "className": "custom-btngroup",
                "targets": -1,
                "data": null,
                "render": function ( data, type, row ) {
                    var enable_disable = '';
                    if(row.status == 1){
                        enable_disable = `<a class="dropdown-item disable" href="javascript:void(0)">Idle</a>`;
                    }else{
                        enable_disable = `<a class="dropdown-item enable" href="javascript:void(0)">Active</a>`;
                    }
                    enable_disable = '';
                    var jsonString = JSON.stringify(row);
                    var td = `
                           <td>
                               <div class="dropdown ms-auto text-end c-pointer">
                                   <div class="btn-link" data-bs-toggle="dropdown" aria-expanded="false">
                                       <svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                           <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                               <rect x="0" y="0" width="24" height="24"></rect>
                                               <circle fill="#000000" cx="5" cy="12" r="2"></circle>
                                               <circle fill="#000000" cx="12" cy="12" r="2"></circle>
                                               <circle fill="#000000" cx="19" cy="12" r="2"></circle>
                                           </g>
                                       </svg>
                                   </div>
                                   <div class="dropdown-menu dropdown-menu-end" style="" data-object='${jsonString}'>
                                       ${enable_disable}
                                       <a class="dropdown-item edit" href="javascript:void(0)">Edit</a>
                                   </div>
                               </div>
                           </td>
                    `;
                    return td;
                },
                "defaultContent": ''
            },
        ],
        "columns": [
           {data: "client_name"},
           {data: "contact_person"},
           {data: "contact_person_mobile"},
           {data: "contact_person_email"},
           {data: "status"},
           {data: "date_added"},
           {data: "client_id"},
        ]
    });

   $("#table thead input").on('keyup change', function(e) {
        if (e.keyCode == 13 || e.keyCode == undefined || this.value == '') {
            table
                .column($(this).parent().index() + ':visible')
                .search(this.value)
                .draw();
        }
   });
   $('#table_filter').hide();
}

$(document).on('click','.disable',function(e){
    e.preventDefault();
    var row = $(this).parent().data('object');
    var client_id = row.client_id;
    var postData = new FormData()
    postData.append('api', '1');
    postData.append('client_id', client_id);
    $.ajax({
        type: 'POST',
        url:  "/<?= $TYPE ?>/client/disable",
        data: postData,
        contentType: false,
        cache: false,
        processData:false,
        beforeSend: function() {
             //$('.as_loader').addClass('show');
        },
        success: function(response){
            if(response.status == '1') {
                table.ajax.reload();
                $.notify(response.message, {type: 'success',align:"center", verticalAlign:"top", close: true});
            }else{
                $.notify(response.message, {type: 'warning',align:"center", verticalAlign:"top", close: true});
            }
            //$('.as_loader').removeClass('show');
        },
        error: function (error) {
            //$('.as_loader').removeClass('show');
        }
    });
});

$(document).on('click','.enable',function(e){
    e.preventDefault();
    var row = $(this).parent().data('object');
    var client_id = row.client_id;
    var postData = new FormData()
    postData.append('api', '1');
    postData.append('client_id', client_id);
    $.ajax({
        type: 'POST',
        url:  "/<?= $TYPE ?>/client/enable",
        data: postData,
        contentType: false,
        cache: false,
        processData:false,
        beforeSend: function() {
             //$('.as_loader').addClass('show');
        },
        success: function(response){
            if(response.status == '1') {
                table.ajax.reload();
                $.notify(response.message, {type: 'success',align:"center", verticalAlign:"top", close: true});
            }else{
                $.notify(response.message, {type: 'warning',align:"center", verticalAlign:"top", close: true});
            }
            //$('.as_loader').removeClass('show');
        },
        error: function (error) {
            //$('.as_loader').removeClass('show');
        }
    });
});

$(document).on('click','.add_new',function(e){
    e.preventDefault();
    $('.parsley-validate').parsley().destroy(); 
    $('.select2-selection--single').removeAttr('style');
    $('#myForm').find('input[name="client_id"]').remove();
    $('#myForm')[0].reset();
    $('.select-single').trigger('change.select2');
    $('#myModel').modal('toggle');
});

$(document).on('click','.edit',function(e){
    e.preventDefault();
    $('.parsley-validate').parsley().destroy(); 
    $('#myForm').find('input[name="client_id"]').remove();

    var row = $(this).parent().data('object');
    var client_id = row.client_id;
    fillForm(row);

    var cnt = row.no_of_licence;
    var hiddenInput = $('<input>').attr({
      type: 'hidden',
      name: 'client_id',
      id: 'client_id',
      value: client_id
    });
    $('#myForm').append(hiddenInput);
    $('#myModel').modal('toggle');
});

$(document).on('click','.save',function(e){
    e.preventDefault();
    $('.parsley-validate').parsley().validate();
    if ($('.parsley-validate').parsley().isValid()){
        var postData = new FormData()
        postData = getFormValues(postData);
        $.ajax({
            type: 'POST',
            url:  "/<?= $TYPE ?>/client/save",
            data: postData,
            contentType: false,
            cache: false,
            processData:false,
            beforeSend: function() {
                 //$('.as_loader').addClass('show');
            },
            success: function(response){
                if(response.status == '1') {
                    table.ajax.reload();
                    $('#myModel').modal('toggle');
                    $.notify(response.message, {type: 'success',align:"center", verticalAlign:"top", close: true});
                }else{
                    $.notify(response.message, {type: 'warning',align:"center", verticalAlign:"top", close: true});
                }
                //$('.as_loader').removeClass('show');
            },
            error: function (error) {
                //$('.as_loader').removeClass('show');
            }
        });
    }
});
</script>
