<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateDriversTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('drivers', function (Blueprint $table) {
            $table->id();
            $table->string('fname')->nullable();
            $table->string('lname')->nullable();
            $table->string('gender')->nullable();
            $table->string('email')->nullable();
            $table->string('mobile')->nullable();
            $table->integer('location')->nullable();
            $table->string('profile_photo')->nullable();
            $table->integer('category')->nullable();
            $table->string('model')->nullable();
            $table->string('brand')->nullable();
            $table->string('year_of_manufacture')->nullable();
            $table->string('registration_number')->nullable();
            $table->text('vehicle_photo')->nullable();
            $table->string('adhar')->nullable();
            $table->string('driving_licence')->nullable();
            $table->string('registration_certificate')->nullable();
            $table->string('availability')->nullable();
            $table->enum('status', ['0', '1', '2', '3'])->default('1');
            $table->timestamps(); // `created_at` and `updated_at`
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('drivers');
    }
}
