<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddContactFieldsToParcelsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('parcels', function (Blueprint $table) {
            $table->string('contact_name')->nullable()->after('delivery_time_window_end');
            $table->string('contact_mobile')->nullable()->after('contact_name');
            $table->dateTime('schedule_ride')->nullable()->after('contact_mobile'); 
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('parcels', function (Blueprint $table) {
            $table->dropColumn(['contact_name', 'contact_mobile', 'schedule_ride']);
        });
    }
}
