@extends('admin.layouts.main')
@section('main.container')
<link href="/taxi/assets/vendor/clockpicker/css/bootstrap-clockpicker.min.css" rel="stylesheet">
<script src="/taxi/assets/vendor/clockpicker/js/bootstrap-clockpicker.min.js"></script>
<style>
    .overlay-container {
        position: relative;
        display: inline-block;
    }

    .overlay-container img.overlay-image {
        display: none;
        position: absolute;
        top: 0;
        left: 0;
        z-index: 10;
        width: 200px; /* Adjust the width as needed */
        height: auto;
    }

    .overlay-container:hover img.overlay-image {
        display: block;
    }
</style>
<div class="content-body">
    <!-- row -->
    <div class="container-fluid">
        <!-- Row -->
        <div class="row">
            <!-- Column starts -->
            <div class="col-xl-12">
                <div class="card" id="accordion-five">
                    <div class="card-header flex-wrap d-flex justify-content-between px-3">
                        <div>
                            <h4 class="card-title">Category</h4>
                            <p class="m-0 subtitle">Note: Please arrange Category</p>
                        </div>
                        <ul class="nav nav-tabs dzm-tabs" id="myTab-4" role="tablist">
                            <li class="nav-item" role="presentation">
                                <a href="javascript:void(0)" class="btn btn-primary add_new">Add New</a>
                            </li>
                        </ul>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table id="table" class="display table" style="min-width: 845px">
                                <thead>
                                    <tr>
                                        <th>Name</th>
                                        <th>Base Fare</th>
                                        <th>Distance Included</th>
                                        <th>Fare Per Km</th>
                                        <th>Status</th>
                                        <th>Created</th>
                                        <th>Action</th>
                                    </tr>
                                    <tr>
                                        <td><input type="text" placeholder="Category" size="10" class="input-fw"/></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td><input type="text" placeholder="Status" size="10" class="input-fw"/></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Column ends -->
    </div>
</div>

<!------- MODAL ------->
<div class="modal right fade" id="myModel" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-center modal-xl" style="width:100%;">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Category</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form role="form" id="myForm" autocomplete="off" enctype='multipart/form-data' class="parsley-validate" data-validate="parsley">
            <div class="modal-body">
                <div class="row">
                    <div class="col-12">
                        <!--This Part is removed it is only here for my ref -->
                        <div class="row">
                            <div class="col-12">
                                <div class="card mb-0">
                                    <div class="card-header p-1">
                                        <h4 class="card-title">General Info</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Name</label>
                                                <input type="text" class="form-control" id="name" name="name" placeholder="Name" data-parsley-required="true">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="tax" class="form-label mb-2">Tax %</label>
                                                <input type="text" class="form-control unsigned_float" id="tax" name="tax" placeholder="Tax" data-parsley-required="true">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Passenger Capacity</label>
                                                <input type="text" class="form-control numeric" id="max_passenger_capacity" name="max_passenger_capacity" placeholder="Passenger Capacity" data-parsley-required="true" data-parsley-type="digits" maxlength="2">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-header p-1">
                                        <h4 class="card-title">Fare Info</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Distance Included In The Base Fare</label>
                                                <input type="text" class="form-control numeric" id="distance_included_in_the_base_fare" name="distance_included_in_the_base_fare" placeholder="Distance Included In The Base Fare" data-parsley-required="true" data-parsley-type="digits" maxlength="3">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Base Fare</label>
                                                <input type="text" class="form-control unsigned_float" id="base_fare" name="base_fare" placeholder="Base Fare" data-parsley-required="true">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Fare Per Km For Extra Run</label>
                                                <input type="text" class="form-control unsigned_float" id="fare_per_km_for_extra_run" name="fare_per_km_for_extra_run" placeholder="Fare Per Km For Extra Run" data-parsley-required="true">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-header p-1">
                                        <h4 class="card-title">Cancellation Fee Info</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="mb-3 col-4">
                                                <label for="driver_cancellation_fee" class="form-label mb-2">Driver Cancellation Fee</label>
                                                <input type="text" class="form-control unsigned_float" id="driver_cancellation_fee" name="driver_cancellation_fee" placeholder="Driver Cancellation Fee" data-parsley-required="true">
                                            </div>
                                        </div>
                                        <div class="row">
                                            <div class="mb-3 col-4">
                                                <label for="user_cancellation_fee" class="form-label mb-2">Rider Cancellation Fee</label>
                                                <input type="text" class="form-control unsigned_float" id="user_cancellation_fee" name="user_cancellation_fee" placeholder="Rider Cancellation Fee" data-parsley-required="true">
                                            </div>
                                        </div>              
                                    </div>
                                    <div class="card-header p-1">
                                        <h4 class="card-title">Peak Hours</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="card-body p-0">
                                                <div class="table-responsive">
                                                    <table class="table table-responsive-sm table-bordered ctm_table_raw_mat" id="myTable">
                                                        <thead>
                                                            <tr>
                                                                <th>Day</th>
                                                                <th>From</th>
                                                                <th>To</th>
                                                                <th>%Increment</th>
                                                                <th class="text-end">Action</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <tr>
                                                                <td>
                                                                    <select class="select-single form-control wide day" name="day" data-placeholder="Day" style="width:200px;" data-parsley-required="true" data-parsley-errors-container="#day_error">
                                                                        <option></option>
                                                                        <?php if($days){ foreach($days as $id => $name){ ?>
                                                                        <option value="<?= $id ?>"><?= $name ?></option>
                                                                        <?php }} ?>
                                                                    </select>
                                                                    <div id="day_error"></div>
                                                                </td>
                                                                <td>
                                                                    <input type="text" class="form-control clockpicker start_time" name="start_time" placeholder="Start Time" style="width:100px;" data-parsley-required="true" readonly>
                                                                </td>
                                                                <td>
                                                                    <input type="text" class="form-control clockpicker end_time" name="end_time" style="width:100px;" placeholder="End Time" data-parsley-required="true" readonly>
                                                                </td>
                                                                <td>
                                                                    <input type="text" class="form-control unsigned_float" name="increment" placeholder="increment" style="width:100px;" data-parsley-required="true">
                                                                </td>
                                                                <td class="text-end">
                                                                </td>
                                                            </tr>
                                                        </tbody>
                                                    </table>
                                                </div>
                                                <div class="p-1 add_more_div">
                                                    <div style="float:right"><button type="button" class="btn btn-light add_more"><i class="fa-solid fa-plus me-2"></i>Add New</button></div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-header p-1">
                                        <h4 class="card-title">Basic Info</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="mb-3 col-4">
                                                <label for="photo" class="form-label">Photo</label>
                                                <input class="form-control form-control-sm file_upload" name="photo" id="photo" type="file">
                                                <ul class="d-flex w-100 border-bottom pb-1 mb-1 fs-6">
                                                    <li class="w-75">
                                                        <div class="overlay-container">
                                                            <a href="javascript:void(0);">
                                                                Hover over me
                                                            </a>
                                                            <img src="" name="photo_img" id="photo_img" alt="Overlay Image" class="overlay-image">
                                                        </div>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary save">Save</button>
           </div>
           </form>
        </div>
    </div>
</div>
<script>
$('.clockpicker').clockpicker({
    placement: 'top',
    donetext: 'Done',
    autoclose: true,
}).find('input').change(function () {
    console.log(this.value);
});

$(document).on('change','.select-single',function(e){
    $(this).parsley().validate();
    if ($(this).parsley().isValid()){
        $(this).find('~ .select2-container .select2-selection--single').removeAttr('style');
    }
});

$(function(){
    $('.select-single').select2({
        dropdownParent: $('#myModel')
    });
});

var table;
$( document ).ready(function() {
    dataTable();
});

function dataTable()
{
    var postData = {'name': 'neeraj'};
    table = $('#table').DataTable({
        pageLength:100,
        paging:true,
        select: false,
        ordering: false,
        info: true,         
        lengthChange:false ,
        language: {
            paginate: {
              next: '<i class="fa-solid fa-angle-right"></i>',
              previous: '<i class="fa-solid fa-angle-left"></i>' 
            }
        },
        "ajax": {
            "url": "/<?= $TYPE ?>/category/index_ajax_category_list",
            "type": "POST",
            data: postData,
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        },
        "initComplete": function(settings, json) {
            //js_switch();
        },
        "columnDefs": [ 
            {
                "className": "custom-btngroup",
                "targets": 4,
                "data": null,
                "render": function ( data, type, row ) {
                    var td = '';
                    if(row.status == 1){
                        td=`
                            <td>
                                <span class="badge light badge-success">
                                    <i class="fa fa-circle text-success me-1"></i>
                                    ${row.status_label}
                                </span>
                            </td>
                        `;
                    }else{
                        td=`
                            <td>
                                <span class="badge light badge-danger">
                                    <i class="fa fa-circle text-danger me-1"></i>
                                    ${row.status_label}
                                </span>
                            </td>
                        `;
                    }
                    return td;
                },
                "defaultContent": ''
            },
            {
                "className": "custom-btngroup",
                "targets": -1,
                "data": null,
                "render": function ( data, type, row ) {
                    var enable_disable = '';
                    if(row.status == 1){
                        enable_disable = `<a class="dropdown-item disable" href="javascript:void(0)">Idle</a>`;
                    }else{
                        enable_disable = `<a class="dropdown-item enable" href="javascript:void(0)">Active</a>`;
                    }
                    var jsonString = JSON.stringify(row);
                    var td = `
                           <td>
                               <div class="dropdown ms-auto text-end c-pointer">
                                   <div class="btn-link" data-bs-toggle="dropdown" aria-expanded="false">
                                       <svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                           <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                               <rect x="0" y="0" width="24" height="24"></rect>
                                               <circle fill="#000000" cx="5" cy="12" r="2"></circle>
                                               <circle fill="#000000" cx="12" cy="12" r="2"></circle>
                                               <circle fill="#000000" cx="19" cy="12" r="2"></circle>
                                           </g>
                                       </svg>
                                   </div>
                                   <div class="dropdown-menu dropdown-menu-end" style="" data-object='${jsonString}'>
                                       ${enable_disable}
                                       <a class="dropdown-item edit" href="javascript:void(0)">Edit</a>
                                   </div>
                               </div>
                           </td>
                    `;
                    return td;
                },
                "defaultContent": ''
            },
        ],
        "columns": [
           {data: "name"},
           {data: "base_fare"},
           {data: "distance_included_in_the_base_fare"},
           {data: "fare_per_km_for_extra_run"},
           {data: "status"},
           {data: "created_at"},
           {data: "id"},
        ]
    });

   $("#table thead input").on('keyup change', function(e) {
        if (e.keyCode == 13 || e.keyCode == undefined || this.value == '') {
            table
                .column($(this).parent().index() + ':visible')
                .search(this.value)
                .draw();
        }
   });
   $('#table_filter').hide();
}

$(document).on('click','.disable',function(e){
    e.preventDefault();
    var row = $(this).parent().data('object');
    var id = row.id;
    var postData = new FormData()
    postData.append('api', '1');
    postData.append('id', id);
    $.ajax({
        type: 'POST',
        url:  "/<?= $TYPE ?>/category/disable",
        data: postData,
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        contentType: false,
        cache: false,
        processData:false,
        beforeSend: function() {
             //$('.as_loader').addClass('show');
        },
        success: function(response){
            if(response.status == '1') {
                table.ajax.reload();
                $.notify(response.message, {type: 'success',align:"center", verticalAlign:"top", close: true});
            }else{
                $.notify(response.message, {type: 'warning',align:"center", verticalAlign:"top", close: true});
            }
            //$('.as_loader').removeClass('show');
        },
        error: function (error) {
            //$('.as_loader').removeClass('show');
        }
    });
});

$(document).on('click','.enable',function(e){
    e.preventDefault();
    var row = $(this).parent().data('object');
    var id = row.id;
    var postData = new FormData()
    postData.append('api', '1');
    postData.append('id', id);
    $.ajax({
        type: 'POST',
        url:  "/<?= $TYPE ?>/category/enable",
        data: postData,
        headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        contentType: false,
        cache: false,
        processData:false,
        beforeSend: function() {
             //$('.as_loader').addClass('show');
        },
        success: function(response){
            if(response.status == '1') {
                table.ajax.reload();
                $.notify(response.message, {type: 'success',align:"center", verticalAlign:"top", close: true});
            }else{
                $.notify(response.message, {type: 'warning',align:"center", verticalAlign:"top", close: true});
            }
            //$('.as_loader').removeClass('show');
        },
        error: function (error) {
            //$('.as_loader').removeClass('show');
        }
    });
});

$(document).on('click', '.add_more', function(e){
    var td = '<div class="d-flex justify-content-end"><a href="javascript:void(0);" class="btn btn-danger shadow btn-xs sharp delete_more"><i class="fa fa-trash"></i></a></div>';
    var clonedRow = $('#myTable tbody tr:first').clone();
    $(clonedRow).find(':input').each(function() {
        var type = this.type;
        var name = this.name;
        $(this).val('');
        $(this).removeClass("parsley-error");
        $(this).closest('td').find('ul.parsley-errors-list').remove();
        var error_id = Math.floor(Math.random() * 1000000000); 
        if (type === 'text'){
            if(name === 'start_time' || name === 'end_time'){
                $(this).clockpicker({
                    placement: 'top',
                    donetext: 'Done',
                    autoclose: true,
                }).find('input').change(function () {
                    console.log(this.value);
                });
            }
        }else if(type === 'select-one') {
            $(this).siblings('span').remove();
            //$(this).attr('data-parsley-errors-container', '#'+error_id);
            //$(this).closest('td').find('div').attr('id', error_id);
            $(this).attr('data-parsley-errors-container', '#'+error_id).after('<div class="error-container" id="'+error_id+'"></div>');
            $(this).select2({
                dropdownParent: $('#myModel')
            });
        }
    });
    $(clonedRow).find('td:last-child').html(td);
    $('#myTable tbody').append(clonedRow);
});

$(document).on('click', '.delete_more', function(e){
    $(this).closest('tr').remove();
});

$(document).on('click','.add_new',function(e){
    e.preventDefault();
    $('.add_more,.save').show();
    $('.parsley-validate').parsley().destroy(); 
    $('.select2-selection--single').removeAttr('style');
    $('#myForm').find('input[name="id"]').remove();
    $('.overlay-container').hide();
    $(".file_upload").val("");
    setTimeout(function() {
        $('.select-single').trigger('change.select2');
    }, 100);
    $('#myForm')[0].reset();
    $('#myTable tbody tr:not(:first)').remove();
    $('#myModel').modal('toggle');
});

$(document).on('click','.edit',function(e){
    e.preventDefault();
    $('.parsley-validate').parsley().destroy(); 
    $('#myForm').find('input[name="id"]').remove();
    $(".file_upload").val("");

    $('#myTable tbody tr:not(:first)').remove();
    var td = '<div class="d-flex justify-content-end"><a href="javascript:void(0);" class="btn btn-danger shadow btn-xs sharp delete_more"><i class="fa fa-trash"></i></a></div>';
    var row = $(this).parent().data('object');
    var id = row.id;
    fillForm(row);
    $('img[name="photo_img"]').parent().hide();
    if(row.photo_img){
        $('img[name="photo_img"]').parent().show();
        $('img[name="photo_img"]').attr('src', row.photo_img);
    }
    if(row.peak_hours){
        var peak_hours = row.peak_hours;
        var ph_count = 0;
        for(var row of peak_hours){
            var clonedRow;
            if(ph_count == 0){
                clonedRow = $('#myTable tbody tr:first');
            }else{
                clonedRow = $('#myTable tbody tr:first').clone();
            }
            $(clonedRow).find(':input').each(function() {
                var type = this.type;
                var name = this.name;
                if (row.hasOwnProperty(name)) {
                    var value = row[name];
                    $(this).val(value);
                }
                $(this).removeClass("parsley-error");
                $(this).closest('td').find('ul.parsley-errors-list').remove();
                var error_id = Math.floor(Math.random() * 1000000000);
                if (type === 'text'){
                    if(name === 'start_time' || name === 'end_time'){
                        $(this).clockpicker({
                            placement: 'top',
                            donetext: 'Done',
                            autoclose: true,
                        }).find('input').change(function () {
                            console.log(this.value);
                        });
                    }
                }else if(type === 'select-one') {
                    $(this).siblings('span').remove();
                    $(this).attr('data-parsley-errors-container', '#'+error_id).after('<div class="error-container" id="'+error_id+'"></div>');
                    $(this).select2({
                        dropdownParent: $('#myModel')
                    });
                }
            });
            if(ph_count > 0){ 
                $(clonedRow).find('td:last-child').html(td);
                $('#myTable tbody').append(clonedRow);
            }
            ph_count++;
        }
    }
    var cnt = row.no_of_licence;
    var hiddenInput = $('<input>').attr({
      type: 'hidden',
      name: 'id',
      id: 'id',
      value: id
    });
    $('#myForm').append(hiddenInput);
    $('#myModel').modal('toggle');
});

$(document).on('click','.save',function(e){
    e.preventDefault();
    $('.parsley-validate').parsley().validate();
    if ($('.parsley-validate').parsley().isValid()){
        var postData = new FormData()
        postData = getFormValues(postData);
        $.ajax({
            type: 'POST',
            url:  "/<?= $TYPE ?>/category/save",
            data: postData,
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            dataTyte: 'json',
            enctype: 'multipart/form-data',
            contentType: false,
            cache: false,
            processData:false,
            beforeSend: function() {
                 //$('.as_loader').addClass('show');
            },
            success: function(response){
                if(response.status == '1') {
                    table.ajax.reload();
                    $('#myModel').modal('toggle');
                    $.notify(response.message, {type: 'success',align:"center", verticalAlign:"top", close: true});
                }else{
                    $.notify(response.message, {type: 'warning',align:"center", verticalAlign:"top", close: true});
                }
                //$('.as_loader').removeClass('show');
            },
            error: function (error) {
                //$('.as_loader').removeClass('show');
            }
        });
    }
});
</script>
@endsection
