@extends('admin.layouts.main')
@section('main.container')
<div class="content-body">
   <!-- row -->
   <div class="container-fluid">
      <!-- Row -->
      <div class="row">
         <div class="col-md-12">
            <div class="card">
               <div class="card-header">
                  <h4 class="card-title">TRIPS</h4>
               </div>
               <div class="card-body">
                  <div class="card-block">
                     <div class="row">
                        <div class="col-md-12">
                           <div class="row px-0">
                              <div class="col-md-6 col-sm-12">
                                 <span class="fs-4"><i class="bi bi-box fs-4"></i></span>
                                 <p class="text-muted"><span class="font-small-4 info text-bold-600">TOTAL TRIPS CREATED</span> / <span class="font-small-4 text-bold-600 success">COMPLETED</span> / <span class="font-small-4 text-bold-600 danger">CANCELLED</span>
                              </div>
                              <div class="col-md-6 col-sm-12">
                                 <!-- <span class="fw-bold fs-3  info"></span> -->
                                 <p class="text-muted text-end" style="margin-top: 8px;"><span class="fw-bold fs-3 info"><?= $trips_stats['OVERALL']->Created ?></span><span class="fw-bold fs-3 "> / </span><span class="fw-bold fs-3  success"><?= $trips_stats['OVERALL']->Completed ?></span><span class="fw-bold fs-3 "> / </span><span class="fw-bold fs-3  danger"><?= $trips_stats['OVERALL']->Cancelled ?></span>
                              </div>
                              <!-- <p class="text-muted">TRIPS</p> -->
                           </div>
                        </div>
                     </div>
                     <div class="row">
                        <div class="col-md-4 col-sm-12 border-right-blue-grey border-right-lighten-5">
                           <div class="media px-0">
                              <p class="text-muted">TODAY <span class="font-small-3 black text-bold-500">(<?= $trips_stats['TODAY']->Date ?>)</span></p>
                           </div>
                           <div>
                              <table class="table table-bordered trip_data mb-0">
                                 <tbody>
                                    <tr>
                                       <td style="width:19%;">
                                          <div class="details-left float-xs-left">
                                             <span class="v-sml text-muted d-block">CREATED</span>
                                             <span class="text-bold-500 info"><?= $trips_stats['TODAY']->Created ?></span>
                                          </div>
                                       </td>
                                       <td style="width:19%;">
                                          <div class="details-left float-xs-left">
                                             <span class="v-sml text-muted d-block">COMPLETED</span>
                                             <span class="text-bold-500 success"><?= $trips_stats['TODAY']->Completed ?></span>
                                          </div>
                                       </td>
                                       <td style="width:19%;">
                                          <div class="details-left float-xs-left">
                                             <span class="v-sml text-muted d-block">CANCELLED</span>
                                             <span class="text-bold-500 danger"><?= $trips_stats['TODAY']->Cancelled ?></span>
                                          </div>
                                       </td>
                                    </tr>
                                 </tbody>
                              </table>
                           </div>
                        </div>
                        <div class="col-xl-4 col-lg-6 col-sm-12 border-right-blue-grey border-right-lighten-5">
                           <div class="media px-0">
                              <p class="text-muted">THIS WEEK <span class="font-small-3 black text-bold-500">(From <?= $trips_stats['WEEK']->Date ?> - Current)</span></p>
                           </div>
                           <div>
                              <table class="table table-bordered trip_data mb-0">
                                 <tbody>
                                    <tr>
                                       <td style="width:19%;">
                                          <div class="details-left float-xs-left">
                                             <span class="v-sml text-muted d-block">CREATED</span>
                                             <span class="text-bold-500 info"><?= $trips_stats['WEEK']->Created ?></span>
                                          </div>
                                       </td>
                                       <td style="width:19%;">
                                          <div class="details-left float-xs-left">
                                             <span class="v-sml text-muted d-block">COMPLETED</span>
                                             <span class="text-bold-500 success"><?= $trips_stats['WEEK']->Completed ?></span>
                                          </div>
                                       </td>
                                       <td style="width:19%;">
                                          <div class="details-left float-xs-left">
                                             <span class="v-sml text-muted d-block">CANCELLED</span>
                                             <span class="text-bold-500 danger"><?= $trips_stats['WEEK']->Cancelled ?></span>
                                          </div>
                                       </td>
                                    </tr>
                                 </tbody>
                              </table>
                           </div>
                        </div>
                        <div class="col-xl-4 col-lg-6 col-sm-12">
                           <div class="media px-0">
                              <p class="text-muted">THIS MONTH <span class="font-small-3 black text-bold-500">(<?= $trips_stats['MONTH']->Date ?>)</span></p>
                           </div>
                           <div>
                              <table class="table table-bordered trip_data mb-0">
                                 <tbody>
                                    <tr>
                                       <td style="width:19%;">
                                          <div class="details-left float-xs-left">
                                             <span class="v-sml text-muted d-block">CREATED</span>
                                             <span class="text-bold-500 info"><?= $trips_stats['MONTH']->Created ?></span>
                                          </div>
                                       </td>
                                       <td style="width:19%;">
                                          <div class="details-left float-xs-left">
                                             <span class="v-sml text-muted d-block">COMPLETED</span>
                                             <span class="text-bold-500 success"><?= $trips_stats['MONTH']->Completed ?></span>
                                          </div>
                                       </td>
                                       <td style="width:19%;">
                                          <div class="details-left float-xs-left">
                                             <span class="v-sml text-muted d-block">CANCELLED</span>
                                             <span class="text-bold-500 danger"><?= $trips_stats['MONTH']->Cancelled ?></span>
                                          </div>
                                       </td>
                                    </tr>
                                 </tbody>
                              </table>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <div class="col-md-12">
            <div class="card">
               <div class="card-header">
                  <h4 class="card-title">PAYMENTS </h4>
               </div>
               <div class="card-body">
                  <div class="card-block">
                     <div class="row">
                        <div class="col-md-4 col-sm-12 border-right-blue-grey border-right-lighten-5">
                           <div class="media flex-wrap px-0">
                              <p class="text-muted w-50 text-start mt-0 mb-0"><i class="bi bi-box fs-4 w-100 d-block"></i></p>
                              <p class="text-muted w-50 text-end mt-0 mb-0" style="line-height:unset;"><span class="fw-bold fs-3 info"><?= $payments_stats['TODAY']->Total ?></span></p>
                              <p class="text-muted w-100 text-start mt-0 mb-0">TODAY <span class="font-small-3 black text-bold-500">(<?= $payments_stats['TODAY']->Date ?>)</span></p>
                           </div>
                           <div>
                              <table class="table table-bordered trip_data mb-0">
                                 <tbody>
                                    <tr>
                                       <td style="width:19%;">
                                          <div class="details-left float-xs-left">
                                             <span class="v-sml text-muted d-block">CASH</span>
                                             <span class="text-bold-500 info"><?= $payments_stats['TODAY']->Cash ?></span>
                                          </div>
                                       </td>
                                       <td style="width:19%;">
                                          <div class="details-left float-xs-left">
                                             <span class="v-sml text-muted d-block">ONLINE</span>
                                             <span class="text-bold-500 success"><?= $payments_stats['TODAY']->Online ?></span>
                                          </div>
                                       </td>
                                    </tr>
                                 </tbody>
                              </table>
                           </div>
                        </div>
                        <div class="col-xl-4 col-lg-6 col-sm-12 border-right-blue-grey border-right-lighten-5">
                           <div class="media flex-wrap px-0">
                              <p class="text-muted w-50 text-start mt-0 mb-0"><i class="bi bi-box fs-4 w-100 d-block"></i></p>
                              <p class="text-muted w-50 text-end mt-0 mb-0" style="line-height:unset;"><span class="fw-bold fs-3 danger"><?= $payments_stats['WEEK']->Total ?></span></p>
                              <p class="text-muted w-100 text-start mt-0 mb-0">THIS WEEK <span class="font-small-3 black text-bold-500">(From <?= $payments_stats['WEEK']->Date ?> - Current)</span></p>
                           </div>
                           <div>
                              <table class="table table-bordered trip_data mb-0">
                                 <tbody>
                                    <tr>
                                       <td style="width:19%;">
                                          <div class="details-left float-xs-left">
                                             <span class="v-sml text-muted d-block">CASH</span>
                                             <span class="text-bold-500 info"><?= $payments_stats['WEEK']->Cash ?></span>
                                          </div>
                                       </td>
                                       <td style="width:19%;">
                                          <div class="details-left float-xs-left">
                                             <span class="v-sml text-muted d-block">ONLINE</span>
                                             <span class="text-bold-500 success"><?= $payments_stats['WEEK']->Online ?></span>
                                          </div>
                                       </td>
                                    </tr>
                                 </tbody>
                              </table>
                           </div>
                        </div>
                        <div class="col-xl-4 col-lg-6 col-sm-12">
                           <div class="media flex-wrap px-0">
                              <p class="text-muted w-50 text-start mt-0 mb-0"><i class="bi bi-box fs-4 w-100 d-block"></i></p>
                              <p class="text-muted w-50 text-end mt-0 mb-0" style="line-height:unset;"><span class="fw-bold fs-3 deep-orange"><?= $payments_stats['MONTH']->Total ?></span></p>
                              <p class="text-muted w-100 text-start mt-0 mb-0">THIS MONTH <span class="font-small-3 black text-bold-500">(<?= $payments_stats['MONTH']->Date ?>)</span></p>
                           </div>
                           <div>
                              <table class="table table-bordered trip_data mb-0">
                                 <tbody>
                                    <tr>
                                       <td style="width:19%;">
                                          <div class="details-left float-xs-left">
                                             <span class="v-sml text-muted d-block">CASH</span>
                                             <span class="text-bold-500 info"><?= $payments_stats['MONTH']->Cash ?></span>
                                          </div>
                                       </td>
                                       <td style="width:19%;">
                                          <div class="details-left float-xs-left">
                                             <span class="v-sml text-muted d-block">ONLINE</span>
                                             <span class="text-bold-500 success"><?= $payments_stats['MONTH']->Online ?></span>
                                          </div>
                                       </td>
                                    </tr>
                                 </tbody>
                              </table>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <div class="col-md-12">
            <div class="card">
               <div class="card-header">
                  <h4 class="card-title">Drivers</h4>
               </div>
               <div class="card-body">
                  <div class="card-block">
                     <div class="row">
                        <div class="col-md-3 col-sm-12 border-right-blue-grey border-right-lighten-5">
                           <div class="media flex-wrap px-0">
                              <p class="text-muted w-50 text-start mt-0 mb-0"><i class="bi bi-box fs-4 w-100 d-block"></i></p>
                              <p class="text-muted w-50 text-end mt-0 mb-0" style="line-height:unset;"><span class="fw-bold fs-3 info"><?= $drivers_stats['Total']->cnt ?></span></p>
                              <p class="text-muted w-100 text-start mt-0 mb-0">Total</p>
                           </div>
                        </div>
                        <div class="col-xl-3 col-lg-6 col-sm-12 border-right-blue-grey border-right-lighten-5">
                           <div class="media flex-wrap px-0">
                              <p class="text-muted w-50 text-start mt-0 mb-0"><i class="bi bi-box fs-4 w-100 d-block"></i></p>
                              <p class="text-muted w-50 text-end mt-0 mb-0" style="line-height:unset;"><span class="fw-bold fs-3 yellow"><?= $drivers_stats['Verified']->cnt ?></span></p>
                              <p class="text-muted w-100 text-start mt-0 mb-0">Verified</p>
                           </div>
                        </div>
                        <div class="col-xl-3 col-lg-6 col-sm-12">
                           <div class="media flex-wrap px-0">
                              <p class="text-muted w-50 text-start mt-0 mb-0"><i class="bi bi-box fs-4 w-100 d-block"></i></p>
                              <p class="text-muted w-50 text-end mt-0 mb-0" style="line-height:unset;"><span class="fw-bold fs-3 danger"><?= $drivers_stats['Unverified']->cnt ?></span></p>
                              <p class="text-muted w-100 text-start mt-0 mb-0">Unverified</p>
                           </div>
                        </div>
                        <div class="col-xl-3 col-lg-6 col-sm-12">
                           <div class="media flex-wrap px-0">
                              <p class="text-muted w-50 text-start mt-0 mb-0"><i class="bi bi-box fs-4 w-100 d-block"></i></p>
                              <p class="text-muted w-50 text-end mt-0 mb-0" style="line-height:unset;"><span class="fw-bold fs-3 deep-orange"><?= $drivers_stats['Available']->cnt ?></span></p>
                              <p class="text-muted w-100 text-start mt-0 mb-0">Available</p>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <div class="col-md-12">
            <div class="card">
               <div class="card-header">
                  <h4 class="card-title">Users</h4>
               </div>
               <div class="card-body">
                  <div class="card-block">
                     <div class="row">
                        <div class="col-md-3 col-sm-12 border-right-blue-grey border-right-lighten-5">
                           <div class="media flex-wrap px-0">
                              <p class="text-muted w-50 text-start mt-0 mb-0"><i class="bi bi-box fs-4 w-100 d-block"></i></p>
                              <p class="text-muted w-50 text-end mt-0 mb-0" style="line-height:unset;"><span class="fw-bold fs-3 info"><?= $users_stats['Total']->cnt ?></span></p>
                              <p class="text-muted w-100 text-start mt-0 mb-0">Total</p>
                           </div>
                        </div>
                        <div class="col-xl-3 col-lg-6 col-sm-12 border-right-blue-grey border-right-lighten-5">
                           <div class="media flex-wrap px-0">
                              <p class="text-muted w-50 text-start mt-0 mb-0"><i class="bi bi-box fs-4 w-100 d-block"></i></p>
                              <p class="text-muted w-50 text-end mt-0 mb-0" style="line-height:unset;"><span class="fw-bold fs-3 yellow"><?= $users_stats['Active']->cnt ?></span></p>
                              <p class="text-muted w-100 text-start mt-0 mb-0">Active</p>
                           </div>
                        </div>
                        <div class="col-xl-3 col-lg-6 col-sm-12">
                           <div class="media flex-wrap px-0">
                              <p class="text-muted w-50 text-start mt-0 mb-0"><i class="bi bi-box fs-4 w-100 d-block"></i></p>
                              <p class="text-muted w-50 text-end mt-0 mb-0" style="line-height:unset;"><span class="fw-bold fs-3 danger"><?= $users_stats['Inactive']->cnt ?></span></p>
                              <p class="text-muted w-100 text-start mt-0 mb-0">Inactive</p>
                           </div>
                        </div>
                        <div class="col-xl-3 col-lg-6 col-sm-12">
                           <div class="media flex-wrap px-0">
                              <p class="text-muted w-50 text-start mt-0 mb-0"><i class="bi bi-box fs-4 w-100 d-block"></i></p>
                              <p class="text-muted w-50 text-end mt-0 mb-0" style="line-height:unset;"><span class="fw-bold fs-3 deep-orange"><?= $users_stats['Deleted']->cnt ?></span></p>
                              <p class="text-muted w-100 text-start mt-0 mb-0">Deleted</p>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </div>
      </div>
      <div class="row">
         <!--column-->
         <div class="col-12">
            <div class="card">
               <div class="card-header py-3 border-0 px-3">
                  <h4 class="heading m-0">Top 10 Drivers</h4>
               </div>
               <div class="card-body p-0">
                  <div class="table-responsive basic-tbl">
                     <div id="teacher-table_wrapper" class="dataTables_wrapper no-footer">
                        <table id="teacher-table" class="tech-data dataTable no-footer" style="min-width: 798px" aria-describedby="teacher-table_info">
                           <thead>
                              <tr>
                                 <th class="sorting sorting_asc" tabindex="0" aria-controls="teacher-table" rowspan="1" colspan="1" style="width: 134.183px;" aria-sort="ascending" aria-label="#: activate to sort column descending">#</th>
                                 <th class="sorting" tabindex="0" aria-controls="teacher-table" rowspan="1" colspan="1" style="width: 211.267px;" aria-label="Name: activate to sort column ascending">Name</th>
                                 <th class="sorting" tabindex="0" aria-controls="teacher-table" rowspan="1" colspan="1" style="width: 303.45px;" aria-label="No. of Trips: activate to sort column ascending">No. of Trips</th>
                                 <th class="text-end sorting" tabindex="0" aria-controls="teacher-table" rowspan="1" colspan="1" style="width: 261px;" aria-label="Turnover: activate to sort column ascending">Turnover</th>
                              </tr>
                           </thead>
                           <tbody>
                            <?php if($top_drivers){ foreach($top_drivers as $r){ ?>
                              <tr class="selected odd">
                                 <td class="sorting_1"><?= $r->driver_id ?></td>
                                 <td><?= $r->name ?></td>
                                 <td><?= $r->tour ?></td>
                                 <td class="text-end"><span class="badge badge-md light badge-danger"><?= $r->payment ?></span></td>
                              </tr>
                            <?php }} ?>
                           </tbody>
                        </table>
                     </div>
                  </div>
               </div>
            </div>
         </div>
         <!--/column-->
      </div>
   </div>
</div>
