<?php

use Illuminate\Support\Facades\Route;
use App\Http\Middleware\Admin\redirectAdminHome;
use App\Http\Middleware\Admin\redirectAdminLogin;
use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\DriverController;
use App\Http\Controllers\Admin\PassengerController;
use App\Http\Controllers\Admin\CategoryController;
use App\Http\Controllers\Admin\LocationController;
use App\Http\Controllers\Admin\DiscountController;
use App\Http\Controllers\Admin\PackageController;
use App\Http\Controllers\Admin\AuthController;
use App\Http\Controllers\Admin\DashboardController;
/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
});

// Admin routes
Route::prefix('admin')->group(function () {
    Route::get('/', [AuthController::class, 'login'])->name('admin.login');
    Route::get('/login', [AuthController::class, 'login'])->name('admin.login')->middleware(redirectAdminHome::class);
    Route::post('/login', [AuthController::class, 'login']);
    Route::get('/logout', [AuthController::class, 'logout']);

    Route::get('/dashboard', [DashboardController::class, 'index'])->name('admin.dashboard')->middleware(redirectAdminLogin::class);

    Route::get('/passenger', [PassengerController::class, 'index'])->name('admin.passenger')->middleware(redirectAdminLogin::class);
    Route::post('/passenger/index_ajax_passenger_list', [PassengerController::class, 'index_ajax_passenger_list'])->middleware(redirectAdminLogin::class);
    Route::post('/passenger/save', [PassengerController::class, 'save'])->middleware(redirectAdminLogin::class);

    Route::get('/driver', [DriverController::class, 'index'])->name('admin.driver')->middleware(redirectAdminLogin::class);
    Route::post('/driver/index_ajax_driver_list', [DriverController::class, 'index_ajax_driver_list'])->middleware(redirectAdminLogin::class);
    Route::post('/driver/save', [DriverController::class, 'save'])->middleware(redirectAdminLogin::class);

    Route::get('/category', [CategoryController::class, 'index'])->name('admin.category')->middleware(redirectAdminLogin::class);
    Route::post('/category/index_ajax_category_list', [CategoryController::class, 'index_ajax_category_list'])->middleware(redirectAdminLogin::class);
    Route::post('/category/save', [CategoryController::class, 'save'])->middleware(redirectAdminLogin::class);

    Route::get('/location', [LocationController::class, 'index'])->name('admin.location')->middleware(redirectAdminLogin::class);
    Route::post('/location/index_ajax_location_list', [LocationController::class, 'index_ajax_location_list'])->middleware(redirectAdminLogin::class);
    Route::post('/location/save', [LocationController::class, 'save'])->middleware(redirectAdminLogin::class);

    Route::get('/discount', [DiscountController::class, 'index'])->name('admin.discount')->middleware(redirectAdminLogin::class);
    Route::post('/discount/index_ajax_discount_list', [DiscountController::class, 'index_ajax_discount_list'])->middleware(redirectAdminLogin::class);
    Route::post('/discount/save', [DiscountController::class, 'save'])->middleware(redirectAdminLogin::class);

    Route::get('/package', [PackageController::class, 'index'])->name('admin.package')->middleware(redirectAdminLogin::class);
    Route::post('/package/index_ajax_package_list', [PackageController::class, 'index_ajax_package_list'])->middleware(redirectAdminLogin::class);
    Route::post('/package/save', [PackageController::class, 'save'])->middleware(redirectAdminLogin::class);
});
