<?php $__env->startSection('main.container'); ?>
<link href="/taxi/assets/vendor/clockpicker/css/bootstrap-clockpicker.min.css" rel="stylesheet">
<script src="/taxi/assets/vendor/clockpicker/js/bootstrap-clockpicker.min.js"></script>
<style>
    .overlay-container {
        position: relative;
        display: inline-block;
    }

    .overlay-container img.overlay-image {
        display: none;
        position: absolute;
        top: 0;
        left: 0;
        z-index: 10;
        width: 200px; /* Adjust the width as needed */
        height: auto;
    }

    .overlay-container:hover img.overlay-image {
        display: block;
    }
</style>
<div class="content-body">
    <!-- row -->
    <div class="container-fluid">
        <!-- Row -->
        <div class="row">
            <!-- Column starts -->
            <div class="col-xl-12">
                <div class="card" id="accordion-five">
                    <div class="card-header flex-wrap d-flex justify-content-between px-3">
                        <div>
                            <h4 class="card-title">Trip</h4>
                            <p class="m-0 subtitle">Note: Please arrange Trip</p>
                        </div>
                        <ul class="nav nav-tabs dzm-tabs" id="myTab-4" role="tablist">
                            <li class="nav-item" role="presentation">
                            </li>
                        </ul>
                        <table class="table table-sm w-50 float-end text-end">
                            <tbody>
                                <tr>
                                    <td class="text-end px-2">Min Date</td>
                                    <td class="px-2"><input type="text" id="min" name="min" data-date-format="yyyy-mm-dd" class="form-control"></td>
                                    <td class="text-end px-2">Max Date</td>
                                    <td class="px-2"><input type="text" id="max" name="max" data-date-format="yyyy-mm-dd" class="form-control"></td>
                                </tr>
                            </tbody>
                        </table>


                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table id="table" class="display table" style="min-width: 845px">
                                <thead>
                                    <tr>
                                        <th>Driver Name/Mobile/Email</th>
                                        <th>User Name/Mobile/Email</th>
                                        <th>Pickup Address</th>
                                        <th>Delivery Address</th>
                                        <th>Trip Start Time/End Time</th>
                                        <th>Distance</th>
                                        <th>Payment</th>
                                        <th>Payment Mode</th>
                                        <th>Commission</th>
                                        <th>Tax</th>
                                        <th>Status</th>
                                        <th>Created</th>
                                        <th>Action</th>
                                    </tr>
                                    <tr>
                                        <td><input type="text" placeholder="Driver" size="10" class="input-fw"/></td>
                                        <td><input type="text" placeholder="User" size="10" class="input-fw"/></td>
                                        <td><input type="text" placeholder="Pickup Address" size="10" class="input-fw"/></td>
                                        <td><input type="text" placeholder="Delivery Address" size="10" class="input-fw"/></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                        <td><input type="text" placeholder="Payment Mode" size="10" class="input-fw"/></td>
                                        <td></td>
                                        <td></td>
                                        <td><input type="text" placeholder="Status" size="10" class="input-fw"/></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                </thead>
                                 <tfoot align="right">
                                    <tr>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                    </tr>
                                 </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Column ends -->
    </div>
</div>

<!------- MODAL ------->
<div class="modal right fade" id="myModel" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-center modal-xl" style="width:100%;">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Trip</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form role="form" id="myForm" autocomplete="off" enctype='multipart/form-data' class="parsley-validate" data-validate="parsley">
            <div class="modal-body">
                <div class="row">
                    <div class="col-12">
                        <!--This Part is removed it is only here for my ref -->
                        <div class="row">
                            <div class="col-12">
                                <div class="card mb-0">
                                    <div class="card-header p-1">
                                        <h4 class="card-title">General Info</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Name</label>
                                                <input type="text" class="form-control" id="name" name="name" placeholder="Name">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="weight_unit" class="form-label mb-2">Weight Unit</label>
                                                <select class="select-single form-control wide" name="weight_unit" data-placeholder="Weight Unit" style="width:200px;" data-parsley-required="true" data-parsley-errors-container="#weight_unit_error">
                                                    <option></option>
                                                    <?php if($weight_unit){ foreach($weight_unit as $id => $name){ ?>
                                                    <option value="<?= $id ?>"><?= $name ?></option>
                                                    <?php }} ?>
                                                </select>
                                                <div id="weight_unit_error"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-header p-1">
                                        <h4 class="card-title">Fare Info</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Weight Included In The Base Fare</label>
                                                <input type="text" class="form-control numeric" id="weight_included_in_the_base_fare" name="weight_included_in_the_base_fare" placeholder="Weight Included In The Base Fare" data-parsley-required="true" data-parsley-type="digits" maxlength="3">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Base Fare</label>
                                                <input type="text" class="form-control unsigned_float" id="base_fare" name="base_fare" placeholder="Base Fare" data-parsley-required="true">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Fare For Extra Weight</label>
                                                <input type="text" class="form-control unsigned_float" id="fare_per_for_extra_weight" name="fare_per_for_extra_weight" placeholder="Fare For Extra Weight" data-parsley-required="true">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-header p-1">
                                        <h4 class="card-title">Basic Info</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="mb-3 col-4">
                                                <label for="photo" class="form-label">Photo</label>
                                                <input class="form-control form-control-sm file_upload" name="photo" id="photo" type="file">
                                                <ul class="d-flex w-100 border-bottom pb-1 mb-1 fs-6">
                                                    <li class="w-75">
                                                        <div class="overlay-container">
                                                            <a href="javascript:void(0);">
                                                                Hover over me
                                                            </a>
                                                            <img src="" name="photo_img" id="photo_img" alt="Overlay Image" class="overlay-image">
                                                        </div>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary save">Save</button>
           </div>
           </form>
        </div>
    </div>
</div>
<script>
$('.clockpicker').clockpicker({
    placement: 'top',
    donetext: 'Done',
    autoclose: true,
}).find('input').change(function () {
    console.log(this.value);
});

$(document).on('change','.select-single',function(e){
    $(this).parsley().validate();
    if ($(this).parsley().isValid()){
        $(this).find('~ .select2-container .select2-selection--single').removeAttr('style');
    }
});

$(function(){
    $('.select-single').select2({
        dropdownParent: $('#myModel')
    });
});

var table;
$( document ).ready(function() {
    dataTable();
});

function dataTable()
{
    var postData = {'name': 'neeraj'};
    table = $('#table').DataTable({
        pageLength:100,
        paging:true,
        select: false,
        ordering: false,
        info: true,         
        lengthChange:false ,
        language: {
            paginate: {
              next: '<i class="fa-solid fa-angle-right"></i>',
              previous: '<i class="fa-solid fa-angle-left"></i>' 
            }
        },
        "ajax": {
            "url": "/<?= $TYPE ?>/trip/index_ajax_trip_list",
            "type": "POST",
            data: postData,
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        },
        "initComplete": function(settings, json) {
            //js_switch();
        },
        "columnDefs": [ 
            {
                "className": "custom-btngroup",
                "targets": 10,
                "data": null,
                "render": function ( data, type, row ) {
                    var td = '';
                    if(row.status == 4){
                        td=`
                            <td>
                                <span class="badge light badge-success">
                                    <i class="fa fa-circle text-success me-1"></i>
                                    ${row.status_label}
                                </span>
                            </td>
                        `;
                    }else{
                        td=`
                            <td>
                                <span class="badge light badge-danger">
                                    <i class="fa fa-circle text-danger me-1"></i>
                                    ${row.status_label}
                                </span>
                            </td>
                        `;
                    }
                    return td;
                },
                "defaultContent": ''
            },
            {
                "className": "custom-btngroup",
                "targets": -1,
                "data": null,
                "render": function ( data, type, row ) {
                    var enable_disable = '';
                    if(row.status == 1){
                        enable_disable = `<a class="dropdown-item disable" href="javascript:void(0)">Idle</a>`;
                    }else{
                        enable_disable = `<a class="dropdown-item enable" href="javascript:void(0)">Active</a>`;
                    }
                    enable_disable = '';
                    var jsonString = JSON.stringify(row);
                    var td = `
                           <td>
                               <div class="dropdown ms-auto text-end c-pointer">
                                   <div class="btn-link" data-bs-toggle="dropdown" aria-expanded="false">
                                       <svg width="24px" height="24px" viewBox="0 0 24 24" version="1.1">
                                           <g stroke="none" stroke-width="1" fill="none" fill-rule="evenodd">
                                               <rect x="0" y="0" width="24" height="24"></rect>
                                               <circle fill="#000000" cx="5" cy="12" r="2"></circle>
                                               <circle fill="#000000" cx="12" cy="12" r="2"></circle>
                                               <circle fill="#000000" cx="19" cy="12" r="2"></circle>
                                           </g>
                                       </svg>
                                   </div>
                                   <div class="dropdown-menu dropdown-menu-end" style="" data-object='${jsonString}'>
                                       <a class="dropdown-item view-details" href="javascript:void(0)">View</a>
                                   </div>
                               </div>
                           </td>
                    `;
                    return td;
                },
                "defaultContent": ''
            },
        ],
         "footerCallback": function ( row, data, start, end, display ) {
            var api = this.api(), data;

            var intVal = function ( i ) {
                return typeof i === 'string' ?
                    i.replace(/[\$,]/g, '')*1 :
                    typeof i === 'number' ?
                        i : 0;
            };
            // computing column Total of the complete resultL
            var five = api.column(5,{page:'current'}).data().reduce( function (a, b) {
                    return (intVal(a) + intVal(b)).toFixed(2);
                }, 0 );

            var six = api.column(6,{page:'current'}).data().reduce( function (a, b) {
                    return (intVal(a) + intVal(b)).toFixed(2);
                }, 0 );

            var eight = api.column(8,{page:'current'}).data().reduce( function (a, b) {
                    return (intVal(a) + intVal(b)).toFixed(2);
                }, 0 );

            var nine = api.column(9,{page:'current'}).data().reduce( function (a, b) {
                    return (intVal(a) + intVal(b)).toFixed(2);
                }, 0 );

            $( api.column( 5 ).footer() ).html(five);
            $( api.column( 6 ).footer() ).html(six);
            $( api.column( 8 ).footer() ).html(eight);
            $( api.column( 9 ).footer() ).html(nine);
        },
        "columns": [
           {data: "driver"},
           {data: "users"},
           {data: "pickup"},
           {data: "delivery"},
           {data: "trip"},
           {data: "distance", visible: false},
           {data: "payment", visible: false },
           {data: "pay_mode", visible: false},
           {data: "commission", visible: false},
           {data: "tax", visible: false},
           {data: "status", visible: false},
           {data: "created_at", visible: false},
           {data: "id"},
        ]
    });

   $("#table thead input").on('keyup change', function(e) {
        if (e.keyCode == 13 || e.keyCode == undefined || this.value == '') {
            table
                .column($(this).parent().index() + ':visible')
                .search(this.value)
                .draw();
        }
   });

   $('#min, #max').change( function(e) {
       if (e.keyCode == 13 || e.keyCode == undefined || this.value == '') {
           table.draw();
       }
   } );

   $('#table_filter').hide();
}

const modals = {
  details: {
    title: "Details",
    fields: {
      driver: "Driver",
      users: "Users",
      pickup: "Pickup",
      delivery: "Delivery",
      trip: "Trip",
      distance: "Distance",
      payment: "Payment",
      pay_mode: "Pay Mode",
    commission: "commission",
    tax: "Tax",
    status: "Status",
    created_at: "Created"
    },
  },
}





$(document).on('click','.disable',function(e){
    e.preventDefault();
    var row = $(this).parent().data('object');
    var id = row.id;
    var postData = new FormData()
    postData.append('api', '1');
    postData.append('id', id);
    $.ajax({
        type: 'POST',
        url:  "/<?= $TYPE ?>/client/disable",
        data: postData,
        contentType: false,
        cache: false,
        processData:false,
        beforeSend: function() {
             //$('.as_loader').addClass('show');
        },
        success: function(response){
            if(response.status == '1') {
                table.ajax.reload();
                $.notify(response.message, {type: 'success',align:"center", verticalAlign:"top", close: true});
            }else{
                $.notify(response.message, {type: 'warning',align:"center", verticalAlign:"top", close: true});
            }
            //$('.as_loader').removeClass('show');
        },
        error: function (error) {
            //$('.as_loader').removeClass('show');
        }
    });
});

$(document).on('click','.enable',function(e){
    e.preventDefault();
    var row = $(this).parent().data('object');
    var id = row.id;
    var postData = new FormData()
    postData.append('api', '1');
    postData.append('id', id);
    $.ajax({
        type: 'POST',
        url:  "/<?= $TYPE ?>/client/enable",
        data: postData,
        contentType: false,
        cache: false,
        processData:false,
        beforeSend: function() {
             //$('.as_loader').addClass('show');
        },
        success: function(response){
            if(response.status == '1') {
                table.ajax.reload();
                $.notify(response.message, {type: 'success',align:"center", verticalAlign:"top", close: true});
            }else{
                $.notify(response.message, {type: 'warning',align:"center", verticalAlign:"top", close: true});
            }
            //$('.as_loader').removeClass('show');
        },
        error: function (error) {
            //$('.as_loader').removeClass('show');
        }
    });
});

$(document).on('click','.add_new',function(e){
    e.preventDefault();
    $('.add_more,.save').show();
    $('.parsley-validate').parsley().destroy(); 
    $('.select2-selection--single').removeAttr('style');
    $('#myForm').find('input[name="id"]').remove();
    $('.overlay-container').hide();
    $(".file_upload").val("");
    setTimeout(function() {
        $('.select-single').trigger('change.select2');
    }, 100);
    $('#myForm')[0].reset();
    $('#myModel').modal('toggle');
});

$(document).on('click','.edit',function(e){
    e.preventDefault();
    $('.parsley-validate').parsley().destroy(); 
    $('#myForm').find('input[name="id"]').remove();
    $(".file_upload").val("");

    var row = $(this).parent().data('object');
    var id = row.id;
    fillForm(row);
    $('img[name="photo_img"]').parent().hide();
    if(row.photo_img){
        $('img[name="photo_img"]').parent().show();
        $('img[name="photo_img"]').attr('src', row.photo_img);
    }
    var cnt = row.no_of_licence;
    var hiddenInput = $('<input>').attr({
      type: 'hidden',
      name: 'id',
      id: 'id',
      value: id
    });
    $('#myForm').append(hiddenInput);
    $('#myModel').modal('toggle');
});

$(document).on('click','.save',function(e){
    e.preventDefault();
    $('.parsley-validate').parsley().validate();
    if ($('.parsley-validate').parsley().isValid()){
        var postData = new FormData()
        postData = getFormValues(postData);
        $.ajax({
            type: 'POST',
            url:  "/<?= $TYPE ?>/trip/save",
            data: postData,
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            dataTyte: 'json',
            enctype: 'multipart/form-data',
            contentType: false,
            cache: false,
            processData:false,
            beforeSend: function() {
                 //$('.as_loader').addClass('show');
            },
            success: function(response){
                if(response.status == '1') {
                    table.ajax.reload();
                    $('#myModel').modal('toggle');
                    $.notify(response.message, {type: 'success',align:"center", verticalAlign:"top", close: true});
                }else{
                    $.notify(response.message, {type: 'warning',align:"center", verticalAlign:"top", close: true});
                }
                //$('.as_loader').removeClass('show');
            },
            error: function (error) {
                //$('.as_loader').removeClass('show');
            }
        });
    }
});

$.fn.dataTable.ext.search.push(function(settings, data, dataIndex) {
    var min = $('#min').val();
    var max = $('#max').val();
//    console.log('minDate: ' + min + ' maxDate: ' + max); 
    var date = data[11]; // Date column (index 0)

    // If no date range is selected, do not filter
    if (!min && !max) {
        return true;
    }

    // Use moment.js to parse the date and compare
    var dateMoment = moment(date, 'YYYY-MM-DD');

    // Convert min and max to moment objects
    var minMoment = min ? moment(min, 'YYYY-MM-DD') : null;
    var maxMoment = max ? moment(max, 'YYYY-MM-DD') : null;
//    console.log('MIN: ' + minMoment + ' MAX: ' + maxMoment + ' DATE: ' + dateMoment );

    // Check if the date is within the range
    if (
        (!minMoment || dateMoment.isSameOrAfter(minMoment)) &&
        (!maxMoment || dateMoment.isSameOrBefore(maxMoment))
    ) {
        return true;
    }
    return false;
});

$( document ).ready(function() {
    $('#min, #max').datepicker({
        dateFormat: 'yy-mm-dd',
        onSelect: function(dateText, inst) {
            $(this).datepicker('hide'); // Close the datepicker on selection
        }
    });
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/takeme1/taxi/resources/views/admin/trip/index.blade.php ENDPATH**/ ?>