-- MySQL dump 10.13  Distrib 5.7.44, for Linux (x86_64)
--
-- Host: localhost    Database: takeme_db
-- ------------------------------------------------------
-- Server version	5.7.44

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `admin`
--

DROP TABLE IF EXISTS `admin`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fname` varchar(255) DEFAULT NULL,
  `lname` varchar(255) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `mobile` varchar(255) DEFAULT NULL,
  `gender` enum('m','f','o') DEFAULT NULL,
  `password` varchar(34) NOT NULL,
  `profile_photo` varchar(255) NOT NULL,
  `status` enum('0','1','2') DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mobile` (`mobile`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin`
--

LOCK TABLES `admin` WRITE;
/*!40000 ALTER TABLE `admin` DISABLE KEYS */;
INSERT INTO `admin` VALUES (1,'Atul','Mohindru','atulmohindru@gmail.com','9876543210',NULL,'c4ca4238a0b923820dcc509a6f75849b','','1','2024-07-25 16:46:04','2024-07-25 16:46:04');
/*!40000 ALTER TABLE `admin` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `bank_details`
--

DROP TABLE IF EXISTS `bank_details`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bank_details` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `driver_id` bigint(20) unsigned NOT NULL,
  `bank_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `holder_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `routing_number` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('0','1','2') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bank_details`
--

LOCK TABLES `bank_details` WRITE;
/*!40000 ALTER TABLE `bank_details` DISABLE KEYS */;
INSERT INTO `bank_details` VALUES (1,1,'icici','dheeru','123456','ici34','saving','1','2024-08-08 15:23:27','2024-08-08 15:23:27');
/*!40000 ALTER TABLE `bank_details` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `category`
--

DROP TABLE IF EXISTS `category`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `max_passenger_capacity` int(11) DEFAULT NULL,
  `distance_included_in_the_base_fare` int(11) DEFAULT NULL,
  `base_fare` decimal(11,2) DEFAULT NULL,
  `fare_per_km_for_extra_run` decimal(11,2) DEFAULT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `status` enum('0','1','2') DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `category`
--

LOCK TABLES `category` WRITE;
/*!40000 ALTER TABLE `category` DISABLE KEYS */;
INSERT INTO `category` VALUES (1,'Bike',1,20,100.00,5.00,'1721993141.png','1','2024-07-22 15:41:24','2024-07-26 11:25:41'),(2,'Auto',3,20,150.00,9.00,'1721989845.png','1','2024-07-22 15:42:23','2024-07-26 10:30:45'),(3,'Suv',5,20,500.00,25.00,'1721993190.png','1','2024-07-22 15:43:09','2024-07-26 11:26:30'),(4,'Sedan',3,20,300.00,15.00,'1721993171.png','1','2024-07-22 15:44:00','2024-07-26 11:26:11'),(5,'Mini',3,20,200.00,12.00,'1721993201.png','1','2024-07-22 15:44:49','2024-07-26 11:26:41');
/*!40000 ALTER TABLE `category` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `country`
--

DROP TABLE IF EXISTS `country`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `country` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(3) NOT NULL DEFAULT '',
  `name` varchar(100) NOT NULL DEFAULT '',
  `status` enum('1','0','2') NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=256 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `country`
--

LOCK TABLES `country` WRITE;
/*!40000 ALTER TABLE `country` DISABLE KEYS */;
INSERT INTO `country` VALUES (1,'BL','Alban','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(2,'DZ','Algeria','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(3,'DS','American Samoa','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(4,'AD','Andorra','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(5,'AO','Angola','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(6,'AI','Anguilla','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(7,'AQ','Antarctica','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(8,'AG','Antigua and Barbuda','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(9,'AW','Aruba','2','2024-07-23 11:49:59','2024-07-23 11:49:59'),(10,'AU','Australia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(11,'AT','Austria','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(12,'AZ','Azerbaijan','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(13,'BS','Bahamas','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(14,'BH','Bahrain','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(15,'BD','Bangladesh','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(16,'BB','Barbados','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(17,'BY','Belarus','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(18,'BE','Belgium','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(19,'BZ','Belize','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(20,'BJ','Benin','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(21,'BM','Bermuda','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(22,'BT','Bhutan','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(23,'BO','Bolivia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(24,'BA','Bosnia and Herzegovina','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(25,'BW','Botswana','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(26,'BV','Bouvet Island','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(27,'BR','Brazil','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(28,'IO','British Indian Ocean Territory','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(29,'BN','Brunei Darussalam','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(30,'BG','Bulgaria','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(31,'BF','Burkina Faso','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(32,'BI','Burundi','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(33,'KH','Cambodia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(34,'CM','Cameroon','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(35,'CA','Canada','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(36,'CV','Cape Verde','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(37,'KY','Cayman Islands','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(38,'CF','Central African Republic','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(39,'TD','Chad','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(40,'CL','Chile','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(41,'CN','China','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(42,'CX','Christmas Island','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(43,'CC','Cocos (Keeling) Islands','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(44,'CO','Colombia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(45,'KM','Comoros','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(46,'CG','Congo','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(47,'CK','Cook Islands','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(48,'CR','Costa Rica','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(49,'HR','Croatia (Hrvatska)','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(50,'CU','Cuba','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(51,'CY','Cyprus','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(52,'CZ','Czech Republic','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(53,'DK','Denmark','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(54,'DJ','Djibouti','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(55,'DM','Dominica','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(56,'DO','Dominican Republic','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(57,'TP','East Timor','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(58,'EC','Ecuador','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(59,'EG','Egypt','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(60,'SV','El Salvador','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(61,'GQ','Equatorial Guinea','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(62,'ER','Eritrea','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(63,'EE','Estonia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(64,'ET','Ethiopia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(65,'FK','Falkland Islands (Malvinas)','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(66,'FO','Faroe Islands','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(67,'FJ','Fiji','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(68,'FI','Finland','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(69,'FR','France','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(70,'FX','France, Metropolitan','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(71,'GF','French Guiana','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(72,'PF','French Polynesia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(73,'TF','French Southern Territories','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(74,'GA','Gabon','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(75,'GM','Gambia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(76,'GE','Georgia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(77,'DE','Germany','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(78,'GH','Ghana','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(79,'GI','Gibraltar','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(80,'GK','Guernsey','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(81,'GR','Greece','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(82,'GL','Greenland','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(83,'GD','Grenada','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(84,'GP','Guadeloupe','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(85,'GU','Guam','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(86,'GT','Guatemala','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(87,'GN','Guinea','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(88,'GW','Guinea-Bissau','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(89,'GY','Guyana','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(90,'HT','Haiti','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(91,'HM','Heard and Mc Donald Islands','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(92,'HN','Honduras','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(93,'HK','Hong Kong','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(94,'HU','Hungary','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(95,'IS','Iceland','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(96,'IN','India','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(97,'IM','Isle of Man','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(98,'ID','Indonesia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(99,'IR','Iran (Islamic Republic of)','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(100,'IQ','Iraq','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(101,'IE','Ireland','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(102,'IL','Israel','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(103,'IT','Italy','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(104,'CI','Ivory Coast','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(105,'JE','Jersey','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(106,'JM','Jamaica','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(107,'JP','Japan','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(108,'JO','Jordan','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(109,'KZ','Kazakhstan','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(110,'KE','Kenya','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(111,'KI','Kiribati','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(112,'KP','Korea, Democratic People\'s Republic of','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(113,'KR','Korea, Republic of','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(114,'XK','Kosovo','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(115,'KW','Kuwait','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(116,'KG','Kyrgyzstan','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(117,'LA','Lao People\'s Democratic Republic','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(118,'LV','Latvia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(119,'LB','Lebanon','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(120,'LS','Lesotho','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(121,'LR','Liberia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(122,'LY','Libyan Arab Jamahiriya','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(123,'LI','Liechtenstein','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(124,'LT','Lithuania','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(125,'LU','Luxembourg','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(126,'MO','Macau','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(127,'MK','Macedonia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(128,'MG','Madagascar','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(129,'MW','Malawi','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(130,'MY','Malaysia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(131,'MV','Maldives','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(132,'ML','Mali','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(133,'MT','Malta','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(134,'MH','Marshall Islands','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(135,'MQ','Martinique','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(136,'MR','Mauritania','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(137,'MU','Mauritius','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(138,'TY','Mayotte','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(139,'MX','Mexico','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(140,'FM','Micronesia, Federated States of','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(141,'MD','Moldova, Republic of','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(142,'MC','Monaco','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(143,'MN','Mongolia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(144,'ME','Montenegro','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(145,'MS','Montserrat','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(146,'MA','Morocco','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(147,'MZ','Mozambique','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(148,'MM','Myanmar','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(149,'NA','Namibia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(150,'NR','Nauru','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(151,'NP','Nepal','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(152,'NL','Netherlands','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(153,'AN','Netherlands Antilles','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(154,'NC','New Caledonia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(155,'NZ','New Zealand','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(156,'NI','Nicaragua','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(157,'NE','Niger','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(158,'NG','Nigeria','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(159,'NU','Niue','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(160,'NF','Norfolk Island','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(161,'MP','Northern Mariana Islands','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(162,'NO','Norway','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(163,'OM','Oman','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(164,'PK','Pakistan','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(165,'PW','Palau','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(166,'PS','Palestine','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(167,'PA','Panama','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(168,'PG','Papua New Guinea','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(169,'PY','Paraguay','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(170,'PE','Peru','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(171,'PH','Philippines','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(172,'PN','Pitcairn','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(173,'PL','Poland','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(174,'PT','Portugal','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(175,'PR','Puerto Rico','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(176,'QA','Qatar','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(177,'RE','Reunion','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(178,'RO','Romania','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(179,'RU','Russian Federation','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(180,'RW','Rwanda','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(181,'KN','Saint Kitts and Nevis','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(182,'LC','Saint Lucia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(183,'VC','Saint Vincent and the Grenadines','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(184,'WS','Samoa','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(185,'SM','San Marino','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(186,'ST','Sao Tome and Principe','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(187,'SA','Saudi Arabia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(188,'SN','Senegal','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(189,'RS','Serbia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(190,'SC','Seychelles','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(191,'SL','Sierra Leone','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(192,'SG','Singapore','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(193,'SK','Slovakia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(194,'SI','Slovenia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(195,'SB','Solomon Islands','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(196,'SO','Somalia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(197,'ZA','South Africa','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(198,'GS','South Georgia South Sandwich Islands','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(199,'ES','Spain','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(200,'LK','Sri Lanka','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(201,'SH','St. Helena','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(202,'PM','St. Pierre and Miquelon','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(203,'SD','Sudan','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(204,'SR','Suriname','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(205,'SJ','Svalbard and Jan Mayen Islands','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(206,'SZ','Swaziland','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(207,'SE','Sweden','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(208,'CH','Switzerland','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(209,'SY','Syrian Arab Republic','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(210,'TW','Taiwan','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(211,'TJ','Tajikistan','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(212,'TZ','Tanzania, United Republic of','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(213,'TH','Thailand','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(214,'TG','Togo','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(215,'TK','Tokelau','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(216,'TO','Tonga','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(217,'TT','Trinidad and Tobago','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(218,'TN','Tunisia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(219,'TR','Turkey','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(220,'TM','Turkmenistan','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(221,'TC','Turks and Caicos Islands','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(222,'TV','Tuvalu','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(223,'UG','Uganda','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(224,'UA','Ukraine','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(225,'AE','United Arab Emirates','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(226,'GB','United Kingdom','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(227,'US','United States','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(228,'UM','United States minor outlying islands','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(229,'UY','Uruguay','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(230,'UZ','Uzbekistan','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(231,'VU','Vanuatu','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(232,'VA','Vatican City State','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(233,'VE','Venezuela','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(234,'VN','Vietnam','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(235,'VG','Virgin Islands (British)','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(236,'VI','Virgin Islands (U.S.)','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(237,'WF','Wallis and Futuna Islands','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(238,'EH','Western Sahara','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(239,'YE','Yemen','2','2024-07-23 11:49:59','2024-07-23 11:49:59'),(240,'ZR','Zaire','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(241,'ZM','Zambia','1','2024-07-23 11:49:59','2024-07-23 11:49:59'),(242,'ZW','Zimbabwe','1','2024-07-23 11:49:59','2024-07-23 11:49:59');
/*!40000 ALTER TABLE `country` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `currency`
--

DROP TABLE IF EXISTS `currency`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `currency` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(3) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `symbol` varchar(255) COLLATE utf8mb4_bin DEFAULT NULL,
  `name` varchar(100) COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `status` enum('1','0','2') COLLATE utf8mb4_bin NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_bin;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `currency`
--

LOCK TABLES `currency` WRITE;
/*!40000 ALTER TABLE `currency` DISABLE KEYS */;
INSERT INTO `currency` VALUES (1,'INR','₹','Indian rupee','1','2024-07-23 16:38:50','2024-07-23 16:38:50'),(2,'EUR','€','Euro','1','2024-07-23 16:42:19','2024-07-23 16:42:19'),(3,'GBP','£','Pounds sterling','1','2024-07-23 16:42:19','2024-07-23 16:42:19'),(4,'USD','$','US dollar','1','2024-07-23 16:42:19','2024-07-23 16:42:19'),(5,'JPY','¥','Japanese yen','1','2024-07-23 16:42:19','2024-07-23 16:42:19');
/*!40000 ALTER TABLE `currency` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `customer`
--

DROP TABLE IF EXISTS `customer`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `customer` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `mobile` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `otp` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `otp_expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `customer_mobile_unique` (`mobile`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `customer`
--

LOCK TABLES `customer` WRITE;
/*!40000 ALTER TABLE `customer` DISABLE KEYS */;
INSERT INTO `customer` VALUES (1,'9876543211',NULL,NULL,'2024-07-25 04:09:39','2024-07-30 09:33:25');
/*!40000 ALTER TABLE `customer` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `discount`
--

DROP TABLE IF EXISTS `discount`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `discount` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `code` varchar(255) DEFAULT NULL,
  `type` enum('flat','percent') DEFAULT 'flat',
  `amount` decimal(11,2) DEFAULT '0.00',
  `min_order` decimal(11,2) DEFAULT '0.00',
  `date_from` date DEFAULT NULL,
  `date_to` date DEFAULT NULL,
  `time_from` time DEFAULT NULL,
  `time_to` time DEFAULT NULL,
  `monday` int(11) DEFAULT NULL,
  `tuesday` int(11) DEFAULT NULL,
  `wednesday` int(11) DEFAULT NULL,
  `thursday` int(11) DEFAULT NULL,
  `friday` int(11) DEFAULT NULL,
  `saturday` int(11) DEFAULT NULL,
  `sunday` int(11) DEFAULT NULL,
  `status` enum('0','1','2') DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `discount`
--

LOCK TABLES `discount` WRITE;
/*!40000 ALTER TABLE `discount` DISABLE KEYS */;
INSERT INTO `discount` VALUES (1,'flat 50 % discount','FLAT50','percent',500.00,NULL,NULL,NULL,NULL,NULL,1,1,1,NULL,NULL,NULL,NULL,'1','2024-07-24 06:07:36','2024-07-24 06:08:07');
/*!40000 ALTER TABLE `discount` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `driver`
--

DROP TABLE IF EXISTS `driver`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `driver` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fname` varchar(255) DEFAULT NULL,
  `lname` varchar(255) DEFAULT NULL,
  `gender` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `mobile` varchar(255) DEFAULT NULL,
  `location` int(11) DEFAULT NULL,
  `profile_photo` varchar(255) DEFAULT NULL,
  `category` int(11) DEFAULT NULL,
  `model` varchar(255) DEFAULT NULL,
  `brand` varchar(255) DEFAULT NULL,
  `year_of_manufacture` varchar(255) DEFAULT NULL,
  `registration_number` varchar(255) DEFAULT NULL,
  `vehicle_photo` text,
  `adhar` varchar(255) DEFAULT NULL,
  `driving_licence` varchar(255) DEFAULT NULL,
  `registration_certificate` varchar(255) DEFAULT NULL,
  `availability` varchar(255) DEFAULT NULL,
  `status` enum('0','1','2','3') DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `driver`
--

LOCK TABLES `driver` WRITE;
/*!40000 ALTER TABLE `driver` DISABLE KEYS */;
INSERT INTO `driver` VALUES (1,'neeraj','diwakar','male','neeraj@gmail.com','9999999999',1,'1722000840_blue.jpg',4,'City','Honda','2004','efgrg44444',NULL,'1722000750_7-Gen-1.pdf','1722000750_7-Gen-2.pdf','1722000750_7-Gen-3.pdf','offline','1','2024-07-23 14:38:15','2024-07-26 13:34:00');
/*!40000 ALTER TABLE `driver` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `drivers`
--

DROP TABLE IF EXISTS `drivers`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `drivers` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `fname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lname` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `gender` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `otp` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `otp_expires_at` timestamp NULL DEFAULT NULL,
  `location` int(11) DEFAULT NULL,
  `profile_photo` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `category` int(11) DEFAULT NULL,
  `model` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `brand` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `year_of_manufacture` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `registration_number` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vehicle_insurance` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vehicle_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vehicle_color` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vehicle_photo` text COLLATE utf8mb4_unicode_ci,
  `adhar` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `driving_licence` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `registration_certificate` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `availability` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` enum('0','1','2','3') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `drivers`
--

LOCK TABLES `drivers` WRITE;
/*!40000 ALTER TABLE `drivers` DISABLE KEYS */;
INSERT INTO `drivers` VALUES (1,'test2',NULL,NULL,'test2@gmail.com','9876543211','6884','2024-08-16 07:58:13',NULL,'uploads/profile_photos/profile_photo_1723096600.png',NULL,'3xo','mahindra','2021','up27qw1243','uploads/vi_files/vehicle_insurance_1723096600.png','xuv','white','uploads/vehicle_photo/vehicle_photo_1723096600.png',NULL,'uploads/vl_files/driving_licence_1723096600.png','uploads/rc_files/registration_certificate_1723096600.png',NULL,'1','2024-07-30 17:24:35','2024-08-16 13:18:13');
/*!40000 ALTER TABLE `drivers` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `failed_jobs` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `location`
--

DROP TABLE IF EXISTS `location`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `location` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `zip_code` varchar(255) DEFAULT NULL,
  `country` int(11) DEFAULT NULL,
  `currency` int(11) DEFAULT NULL,
  `distance_unit` varchar(255) DEFAULT NULL,
  `tax` decimal(11,2) DEFAULT NULL,
  `commission` decimal(11,2) DEFAULT NULL,
  `status` enum('0','1','2') DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `location`
--

LOCK TABLES `location` WRITE;
/*!40000 ALTER TABLE `location` DISABLE KEYS */;
INSERT INTO `location` VALUES (1,'India','2222222',96,1,'km',12.00,10.00,'1','2024-07-23 11:18:57','2024-07-23 11:18:57');
/*!40000 ALTER TABLE `location` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `migrations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'2014_10_12_000000_create_users_table',1),(2,'2014_10_12_100000_create_password_resets_table',1),(3,'2019_08_19_000000_create_failed_jobs_table',1),(4,'2019_12_14_000001_create_personal_access_tokens_table',1),(5,'2024_07_25_063438_create_customer_table',2),(6,'2024_07_30_155758_create_drivers_table',3),(7,'2024_07_30_161345_update_timestamps_in_drivers_table',4),(8,'2024_07_30_164832_add_otp_columns_to_drivers_table',5),(10,'2024_08_05_132542_add_more_column_to_drivers',6),(11,'2024_08_08_115554_create_bank_details_table',7),(12,'2024_08_08_124442_update_timestamps_in_bank_details_table',8);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `package`
--

DROP TABLE IF EXISTS `package`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `package` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `weight_unit` varchar(255) DEFAULT NULL,
  `weight_included_in_the_base_fare` int(11) DEFAULT NULL,
  `base_fare` decimal(11,2) DEFAULT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `status` enum('0','1','2') DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `package`
--

LOCK TABLES `package` WRITE;
/*!40000 ALTER TABLE `package` DISABLE KEYS */;
INSERT INTO `package` VALUES (1,'panga','kg',5,23.00,'1721803462.jpg','1','2024-07-24 06:44:22','2024-07-24 07:21:41');
/*!40000 ALTER TABLE `package` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `passenger`
--

DROP TABLE IF EXISTS `passenger`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `passenger` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `mobile` varchar(255) DEFAULT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `gender` enum('m','f','o') DEFAULT NULL,
  `status` enum('0','1','2') DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mobile` (`mobile`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `passenger`
--

LOCK TABLES `passenger` WRITE;
/*!40000 ALTER TABLE `passenger` DISABLE KEYS */;
INSERT INTO `passenger` VALUES (1,'neeraj','neerajdiwakar@gmail.com','9868659088',NULL,NULL,'1','2024-07-19 18:03:42','2024-07-19 18:03:42'),(2,'kamalaa','fdf@ddg.com','9999999999','1721409447.png',NULL,'1','2024-07-19 13:33:01','2024-07-19 17:17:27');
/*!40000 ALTER TABLE `passenger` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_resets`
--

DROP TABLE IF EXISTS `password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `password_resets` (
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `password_resets_email_index` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_resets`
--

LOCK TABLES `password_resets` WRITE;
/*!40000 ALTER TABLE `password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `peak_hours`
--

DROP TABLE IF EXISTS `peak_hours`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `peak_hours` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) DEFAULT NULL,
  `day` int(11) DEFAULT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `increment` decimal(11,2) DEFAULT NULL,
  `status` enum('0','1','2') DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `category_id` (`category_id`)
) ENGINE=InnoDB AUTO_INCREMENT=17 DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `peak_hours`
--

LOCK TABLES `peak_hours` WRITE;
/*!40000 ALTER TABLE `peak_hours` DISABLE KEYS */;
INSERT INTO `peak_hours` VALUES (10,2,2,'18:00:00','20:00:00',10.00,'1','2024-07-26 10:30:45','2024-07-26 10:30:45'),(11,2,3,'16:05:00','19:15:00',10.00,'1','2024-07-26 10:30:45','2024-07-26 10:30:45'),(12,1,1,'18:15:00','20:20:00',5.00,'1','2024-07-26 11:25:41','2024-07-26 11:25:41'),(13,1,1,'08:10:00','10:15:00',5.00,'1','2024-07-26 11:25:41','2024-07-26 11:25:41'),(14,4,2,'18:10:00','20:15:00',10.00,'1','2024-07-26 11:26:12','2024-07-26 11:26:12'),(15,3,3,'18:10:00','20:15:00',10.00,'1','2024-07-26 11:26:30','2024-07-26 11:26:30'),(16,5,1,'18:10:00','20:15:00',10.00,'1','2024-07-26 11:26:41','2024-07-26 11:26:41');
/*!40000 ALTER TABLE `peak_hours` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fname` varchar(255) DEFAULT NULL,
  `lname` varchar(255) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `mobile` varchar(255) DEFAULT NULL,
  `gender` enum('m','f','o') DEFAULT NULL,
  `password` varchar(34) NOT NULL,
  `profile_photo` varchar(255) NOT NULL,
  `status` enum('0','1','2') DEFAULT '1',
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mobile` (`mobile`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users_old`
--

DROP TABLE IF EXISTS `users_old`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `users_old` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users_old`
--

LOCK TABLES `users_old` WRITE;
/*!40000 ALTER TABLE `users_old` DISABLE KEYS */;
/*!40000 ALTER TABLE `users_old` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2024-08-16 13:24:40
