<?php

require __DIR__ . '/vendor/autoload.php';

use Ratchet\Server\IoServer;
use Ratchet\Http\HttpServer;
use Ratchet\WebSocket\WsServer;
use React\EventLoop\Loop;
use React\Socket\SocketServer;

class WebSocketHandler implements \Ratchet\MessageComponentInterface {
    public function onOpen(\Ratchet\ConnectionInterface $conn) {
        echo "New connection! ({$conn->resourceId})\n";
    }

    public function onMessage(\Ratchet\ConnectionInterface $conn, $msg) {
        echo "Received message: {$msg}\n";
        $conn->send("Echo: {$msg}");
    }

    public function onClose(\Ratchet\ConnectionInterface $conn) {
        echo "Connection closed! ({$conn->resourceId})\n";
    }

    public function onError(\Ratchet\ConnectionInterface $conn, \Exception $e) {
        echo "An error occurred: {$e->getMessage()}\n";
        $conn->close();
    }
}

$loop = Loop::get();
$webSock = new SocketServer('0.0.0.0:6003', [], $loop);

$server = new IoServer(
    new HttpServer(
        new WsServer(
            new WebSocketHandler()
        )
    ),
    $webSock,
    $loop
);

echo "WebSocket server running on ws://0.0.0.0:6003\n";
$loop->run();
