<?php

// Create a simple WebSocket server using Tinker

use Ratchet\Server\IoServer;
use Ratchet\WebSocket\WsServer;
use Ratchet\ConnectionInterface;
use Ratchet\MessageComponentInterface;

require __DIR__ . '/vendor/autoload.php'; // Ensure Composer autoload is included

class TestWebSocket implements MessageComponentInterface
{
    protected $clients;

    public function __construct()
    {
        $this->clients = new \SplObjectStorage;
    }

    public function onOpen(ConnectionInterface $conn)
    {
        $this->clients->attach($conn);
        echo "New connection! ({$conn->resourceId})\n";
    }

    public function onMessage(ConnectionInterface $from, $msg)
    {
        echo sprintf('Connection %d sending message "%s" to %d other connection(s)' . "\n"
            , $from->resourceId, $msg, count($this->clients) - 1);

        foreach ($this->clients as $client) {
            if ($client !== $from) {
                // The sender is not the receiver, send to each client connected
                $client->send($msg);
            }
        }
    }

    public function onClose(ConnectionInterface $conn)
    {
        $this->clients->detach($conn);
        echo "Connection {$conn->resourceId} has disconnected\n";
    }

    public function onError(ConnectionInterface $conn, \Exception $e)
    {
        echo "An error has occurred: {$e->getMessage()}\n";
        $conn->close();
    }
}

// Start the WebSocket server
$server = IoServer::factory(
    new WsServer(
        new TestWebSocket()
    ),
    6002 // Choose a port (e.g., 8080)
);

echo "WebSocket server started on port 6002\n";

$server->run();
