const player = document.body.querySelector("amp-story-player");
const lightboxEl = document.querySelector(".lightbox");

if (player.isReady) {
  initializeCarousel();
} else {
  player.addEventListener("ready", () => {
    initializeCarousel();
  });
}

function initializeCarousel() {
  const stories = player.getStories();

  const thumbnails = document.querySelectorAll(
    ".entry-point-card-container img"
  );

  thumbnails.forEach((img, idx) => {
    img.addEventListener("click", () => {
      player.show(stories[idx].href);
      player.play();
      lightboxEl.classList.toggle("show");
    });
  });
}

player.addEventListener("amp-story-player-close", () => {
  player.pause();
  lightboxEl.classList.toggle("show");
});
