import React from 'react';
import { fp, hp, wp } from '../../helpers/Dimensions';
import { View, Text, TouchableOpacity, Image, StyleSheet } from 'react-native';
import { FORWARDBUTTON } from '../../assets/Icon';
import Buttonblack from '../Buttonblack';
import Textbox from '../Textbox';

export const MODAL_STEPS = {
  ARRIVED: 'arrived',
  OTP: 'otp',
  VERIFIED: 'verified',
  START_RIDE: 'start_ride',
};

export const renderModalContent = (step, {
  otp,
  setOtp,
  data,
  functionName,
  handleModal,
  onClose,
  cancleRideFunc
}) => {
  switch (step) {
    case MODAL_STEPS.ARRIVED:
      return (
        <Buttonblack
          title="Reached Location"
          wide="70"
          style={{ backgroundColor: '#FFC727' }}
        />
      );

    case MODAL_STEPS.OTP:
      return (
        <>
          <View style={styles.otpContainer}>
            <Text style={styles.txtSmallBold}>Submit OTP & Start Ride</Text>
            <View style={{ flexDirection: 'row', justifyContent: 'center', alignItems: 'center' }}>
              <Textbox title="OTP" wide="60" val={otp} changetext={setOtp} />
              <Image source={FORWARDBUTTON} />
            </View>
          </View>
          <Buttonblack
            title="Submit OTP"
            wide="70"
            onPress={() => functionName(otp, data?.id)}
          />
        </>
      );

    case MODAL_STEPS.VERIFIED:
      return (
        <>
          <Text style={styles.txtNormalBold}>Congrats {data?.user?.name}</Text>
          <Buttonblack
            title="Ride Start"
            wide="80"
            onPress={() => functionName('', data?.id, 'ride_start')}
          />
          <TouchableOpacity onPress={() => cancleRideFunc(data?.id)}>
            <Text style={styles.txtNormalRed}>Cancel Ride</Text>
          </TouchableOpacity>
        </>
      );

    default:
      return null;
  }
};

const styles = StyleSheet.create({
    otpContainer: {
            width: wp(90),
            alignItems: "center",
            margin: 10
    },
    txtSmallBold: {
            color: "#000000",
            fontSize: fp(1.5),
            fontWeight: "bold"
        },
    txtNormalBold: {
            color: "#000000",
            fontSize: fp(2),
            fontWeight: "bold"
        },
    txtNormalRed: {
            color: "red",
            fontSize: fp(2),
        },
})
