import { StyleSheet, Text, View, TouchableOpacity  } from 'react-native'
import React from 'react'
import { fp, hp, wp } from '../helpers/Dimensions'

const Buttonblack = (props) => {
    const {title, wide} = props

  return (
    <TouchableOpacity {...props}>
    <View style={styles.btnContainer}>
        <View style={[styles.btnBlack, {width: wp(wide)}]}>
            <Text style={styles.btnBlackText}>{title}</Text>
        </View>
    </View>
    </TouchableOpacity>

  )
}

export default Buttonblack

const styles = StyleSheet.create({
    btnContainer: {
        //width: wp(100),
        height: hp(8),
        alignItems: "center",
        justifyContent: "center",
        backgroundColor: "#FFFFFF"
    },
    btnBlack: {
        //width: wp(90),
        marginTop: 5,
        marginBottom: 5,
        padding: 15,
        borderRadius: 15,
        textAlign: "center",
        backgroundColor: "#000001"
    },
    btnBlackText: {
        textAlign: "center",
        color: "#c2982a",
        fontSize: fp(2),
        fontWeight: "bold"
    }


})