import { StyleSheet, Text, View, TextInput } from 'react-native'
import React from 'react'
import { hp, wp } from '../helpers/Dimensions'


const Textarea = (props) => {
    const { title, wide, rfn, val, changetext } = props

    return (
        <View style={styles.mainContainer}>
            <TextInput style={[styles.inpt, { width: wp(wide), }, props.inputstyle]}
                placeholder={title}
                ref={rfn}
                value={val}
                onChangeText={changetext}
                multiline={true}
                numberOfLines={5} />
        </View>
    )
}

export default Textarea

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(10),
        alignItems: "center",
        padding: 5

    },
    inpt: {
        width: wp(90),
        borderRadius: 15,
        borderWidth: 1,
        borderColor: "#223138",
        paddingHorizontal: 10
    }
})