import { StyleSheet, Text, View, Alert, ActivityIndicator } from 'react-native'
import React, { useEffect, useState } from 'react'
import { createNativeStackNavigator } from '@react-navigation/native-stack'
import { NavigationContainer } from '@react-navigation/native';
import Splash from '../screens/Splash/Splash';
import Welcome from '../screens/Welcome/Welcome';
import Login from '../screens/Login/Login';
import Verify from '../screens/Verify/Verify';
import Profile from '../screens/Profile/Profile';
import Documents from '../screens/Documents/Documents';
import Photo from '../screens/Photo/Photo';
import Drivinglicence from '../screens/Drivinglicence/Drivinglicence';
import Vehicleinsurance from '../screens/Vehicleinsurance/Vehicleinsurance';
import Registrationcertificate from '../screens/Registrationcertificate/Registrationcertificate';
import Bank from '../screens/Bank/Bank';
import Location from '../screens/Location/Location';
import Inspectionpoints from '../screens/Inspectionpoints/Inspectionpoints';
import Legalconsent from '../screens/Legalconsent/Legalconsent';
import Profilecompleted from '../screens/Profilecompleted/Profilecompleted';
import Ride from '../screens/Ride/Ride';
import Myrides from '../screens/Myrides/Myrides';
import Earnings from '../screens/Earnings/Earnings';
import Earningactivity from '../screens/Earningactivity/Earningactivity';
import About from '../screens/About/About';
import Privacypolicy from '../screens/Privacypolicy/Privacypolicy';
import Termsnconditions from '../screens/Termsnconditions/Termsnconditions';
import Contact from '../screens/Contact/Contact';
import Dashboard from '../screens/Dashboard/Dashboard';
import Rideaccept from '../screens/Rideaccept/Rideaccept';
import Cancelride from '../screens/Cancelride/Cancelride';
import Ridestart from '../screens/Ridestart/Ridestart';
import Rideend from '../screens/Rideend/Rideend';
import Ridetrack from '../screens/Ridetrack/Ridetrack';
import RideStepFirst from '../screens/Ride/Rideinfo';
import Feedback from '../screens/Feedback/Feedback';
import Incident from '../screens/Incident/Incident';
import Payment from '../screens/Payment/Payment';
import Paymentsuccess from '../screens/Paymentsuccess/Paymentsuccess';
import Map from '../screens/Map/Map';
import AsyncStorage from '@react-native-async-storage/async-storage';
import { getFromStorage } from '../utils/storageHelper';


const Navigation = () => {

   const stack = createNativeStackNavigator();
   const [initialScreen, setInitialScreen]  = useState('Splash');
   const [lastRideId, setLastRideId]        = useState(null);
   const [initialRoute, setInitialRoute] = useState(null);

   const checkLogin = async () => {
    const storedData = await getFromStorage('login_dtl');
    const storeParse = JSON.parse(storedData);
    if (storeParse?.id) {
      setInitialRoute('Dashboard');
      //setInitialRoute('Splash');
    } else {
      setInitialRoute('Splash');
    }
  };

    useEffect(() => {
        checkLogin();
        const checkLastScreen = async () => {
            const lastScreen = await getFromStorage('lastScreen');
            if (lastScreen) {
                setInitialScreen(lastScreen);
            }
        };
        checkLastScreen();

        const interval = setInterval(async () => {
            try {
                const response = await fetch("https://takeme.greathub.in/taxi/api/ride-latest");
                const respJson = await response.json();
                console.log("navigation76=== ", respJson);
                
                if (respJson.status == 1  && respJson.data) {
                    var parcel_id  = respJson.data[0].id;
                   
                    setLastRideId((prevRideId) => {
                        
                        if (prevRideId !== parcel_id) {
                            Alert.alert("New Ride Alert", "A new ride has been created!");
                            return parcel_id;
                        }
                        return prevRideId;
                    });
                }
            } catch (error) {
                //console.log("Error fetching ride data:", error);
            }
        }, 2000);

        return () => clearInterval(interval);


    }, []);
   

if (!initialRoute) {
  return (
    <View style={styles.loaderContainer}>
      <ActivityIndicator size="large" color="#007bff" />
    </View>
  );
}

return (
    <NavigationContainer>
        <stack.Navigator initialRouteName={initialRoute} screenOptions={{headerShown: false}}>
            <stack.Screen name="Splash" component={Splash} />
            <stack.Screen name="Welcome" component={Welcome} />
            <stack.Screen name="Login" component={Login} />
            <stack.Screen name="Verify" component={Verify} />
            <stack.Screen name="Profile" component={Profile} />
            <stack.Screen name="Dashboard" component={Dashboard} />
            <stack.Screen name="Rideaccept" component={Rideaccept} />
            <stack.Screen name="Cancelride" component={Cancelride} />
            <stack.Screen name="Ridestart" component={Ridestart} />
            <stack.Screen name="Ridetrack" component={Ridetrack} />
            <stack.Screen name="Rideend" component={Rideend} />
            <stack.Screen name="RideStepFirst" component={RideStepFirst} />
            <stack.Screen name="Payment" component={Payment} />
            <stack.Screen name="Paymentsuccess" component={Paymentsuccess} />
            <stack.Screen name="Feedback" component={Feedback} />
            <stack.Screen name="Myrides" component={Myrides} />
            <stack.Screen name="Incident" component={Incident} />
            <stack.Screen name="Map" component={Map} />

            <stack.Screen name="Documents" component={Documents} />
            <stack.Screen name="Photo" component={Photo} />
            <stack.Screen name="Drivinglicence" component={Drivinglicence} />
            <stack.Screen name="Vehicleinsurance" component={Vehicleinsurance} />
            <stack.Screen name="Registrationcertificate" component={Registrationcertificate} />
            <stack.Screen name="Bank" component={Bank} />
            <stack.Screen name="Location" component={Location} />
            <stack.Screen name="Inspectionpoints" component={Inspectionpoints} />
            <stack.Screen name="Legalconsent" component={Legalconsent} />
            <stack.Screen name="Profilecompleted" component={Profilecompleted} />
            <stack.Screen name="Ride" component={Ride} />
            
            <stack.Screen name="Earnings" component={Earnings} />
            <stack.Screen name="Earningactivity" component={Earningactivity} />
            <stack.Screen name="About" component={About} />
            <stack.Screen name="Privacypolicy" component={Privacypolicy} />
            <stack.Screen name="Termsnconditions" component={Termsnconditions} />
            <stack.Screen name="Contact" component={Contact} />
        </stack.Navigator>
    </NavigationContainer>
)
}

export default Navigation

const styles = StyleSheet.create({})