import { StyleSheet, Text, View, Image, TouchableOpacity } from 'react-native'
import React from 'react'
import { fp, hp, wp } from '../../helpers/Dimensions'
import Header from '../../components/Header'
import { BACK, CIRCLE, FORWARDGREY, LOGO } from '../../assets/Icon'
import { useNavigation } from '@react-navigation/native'

const Documents = () => {
    const navigation = useNavigation()

    return (

        <View style={styles.mainContainer}>
            <Header title="Add Documents" link="Profile" />
            <View style={styles.imgContainer}>
                <Image source={LOGO} />
            </View>
            <View style={styles.labelContainer}>
                <Text style={styles.textH2}>Please fill required steps</Text>
                <Text style={styles.textNormal}>Here's what you need to do to set up your account</Text>
            </View>
            <View style={styles.textBoxContainer}>
                <View style={{ width: wp(15), paddingLeft: 5 }}>
                    <Image source={CIRCLE} />
                </View>
                <TouchableOpacity onPress={() => navigation.navigate("Photo")}>
                    <View style={{ width: wp(75) }}>
                        <Text style={styles.textH2}>Profile Photo</Text>
                        <Text style={styles.textNormal}>Recommended next step</Text>
                    </View>
                </TouchableOpacity>
                <TouchableOpacity onPress={() => navigation.navigate("Photoupload")}>
                    <View style={{ width: wp(5) }}>
                        <Image source={FORWARDGREY} />
                    </View>
                </TouchableOpacity>
            </View>
            <View style={styles.greyLine}></View>
            <View style={styles.textBoxContainer}>
                <View style={{ width: wp(15), paddingLeft: 5 }}>
                    <Image source={CIRCLE} />
                </View>
                <TouchableOpacity onPress={() => navigation.navigate("Drivinglicence")}>
                    <View style={{ width: wp(75) }}>
                        <Text style={styles.textH2}>Driver License - Front & Back</Text>
                        <Text style={styles.textNormal}>Get Started</Text>
                    </View>
                </TouchableOpacity>
                <TouchableOpacity onPress={() => navigation.navigate("Drivinglicence")}>
                    <View style={{ width: wp(5) }}>
                        <Image source={FORWARDGREY} />
                    </View>
                </TouchableOpacity>
            </View>
            <View style={styles.greyLine}></View>
            <View style={styles.textBoxContainer}>
                <View style={{ width: wp(15), paddingLeft: 5 }}>
                    <Image source={CIRCLE} />
                </View>
                <View style={{ width: wp(75), paddingLeft: 5 }}>
                    <TouchableOpacity onPress={() => navigation.navigate("Vehicleinsurance")}>
                        <Text style={styles.textH2}>Vehicle Insurance</Text>
                        <Text style={styles.textNormal}>Get Started</Text>
                    </TouchableOpacity>
                </View>
                <View style={{ width: wp(5) }}>
                    <TouchableOpacity onPress={() => navigation.navigate("Vehicleinsurance")}>
                        <Image source={FORWARDGREY} />
                    </TouchableOpacity>
                </View>
            </View>
            <View style={styles.greyLine}></View>
            <View style={styles.textBoxContainer}>
                <View style={{ width: wp(15), paddingLeft: 5 }}>
                    <Image source={CIRCLE} />
                </View>
                <TouchableOpacity onPress={() => navigation.navigate("Registrationcertificate")}>
                    <View style={{ width: wp(75) }}>
                        <Text style={styles.textH2}>Registration Certificate (RC)</Text>
                        <Text style={styles.textNormal}>Get Started</Text>
                    </View>
                </TouchableOpacity>
                <TouchableOpacity onPress={() => navigation.navigate("Registrationcertificate")}>
                    <View style={{ width: wp(5) }}>
                        <Image source={FORWARDGREY} />
                    </View>
                </TouchableOpacity>
            </View>
            <View style={styles.greyLine}></View>
            <View style={styles.textBoxContainer}>
                <View style={{ width: wp(15), paddingLeft: 5 }}>
                    <Image source={CIRCLE} />
                </View>
                <TouchableOpacity onPress={() => navigation.navigate("Bank")}>
                    <View style={{ width: wp(75) }}>
                        <Text style={styles.textH2}>Bank Details</Text>
                        <Text style={styles.textNormal}>Get Started</Text>
                    </View>
                </TouchableOpacity>
                <TouchableOpacity onPress={() => navigation.navigate("Bank")}>
                    <View style={{ width: wp(5) }}>
                        <Image source={FORWARDGREY} />
                    </View>
                </TouchableOpacity>
            </View>
        </View>

    )
}

export default Documents

const styles = StyleSheet.create({

    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(20),
        justifyContent: "center",
        alignItems: "center"
    },
    labelContainer: {
        backgroundColor: "#FFFFFF",
        //height: hp(5),
        width: wp(90),
        alignSelf: "center"
    },
    textBoxContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(12),
        width: wp(100),
        alignItems: "center",
        flexDirection: "row",
        justifyContent: "space-evenly",
        alignSelf: "center"
    },
    resendCodeContainter: {
        backgroundColor: "#FFFFFF",
        width: wp(100),
        height: hp(5),
        flexDirection: "row",
        justifyContent: "space-evenly"
    },
    textH2: {
        fontSize: fp(2),
        fontWeight: "bold",
        color: "#000000",
        //paddingLeft: 5
    },
    textNormal: {
        fontSize: fp(1.5),
        color: "#000000"
    },
    greyLine: {
        width: '90%',   // Adjust the width as needed
        height: 1,      // Adjust the height as needed
        backgroundColor: 'grey',
        alignSelf: "center"
    },

})