import { StyleSheet, Text, View, Image, TouchableOpacity } from 'react-native'
import React from 'react'
import { fp, hp, wp } from '../../helpers/Dimensions'
import Header from '../../components/Header'
import { COST, LOGO, MAP, THUMBSUP } from '../../assets/Icon'
import { useNavigation } from '@react-navigation/native'
import Buttonblack from '../../components/Buttonblack'

const Paymentsuccess = () => {
    const navigation = useNavigation()

    return (
        <View style={styles.mainContainer}>
            <Header title="Payment" link="Profile" />
            <View style={styles.imgContainer}>
                <Image source={THUMBSUP} />
            </View>
            <View style={styles.costContainer}>
                <Text style={styles.textH5}>Success</Text>
                <Text style={styles.textH1}>You have received USD 56</Text>
            </View>            
            <Buttonblack title="Feedback" wide="80" onPress={() => navigation.navigate("Feedback")}/>
        </View>
    )
}

export default Paymentsuccess

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(40),
        justifyContent: "center",
        alignItems: "center"
    },
    costContainer: {
        backgroundColor: "#FFFFFF",
        width:wp(80),
        height: hp(25),
        justifyContent: "center",
        alignSelf: "center",
        alignItems: "center",
    },    
    qrcContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(20),
        justifyContent: "center",
        alignItems: "center"
    },
    poContainer: {
        backgroundColor: "#B4B4B4",
        height:hp(20),
        width:wp(80),
        justifyContent: "flex-start",
        alignSelf: "center",
        padding: 20,
        borderRadius: 20,
    },
    povContainer: {
        backgroundColor: "#B4B4B4",
        flexDirection: "row",
        margin: 5
    },
    textH5: {
        color: "#219A0E",
        fontSize: fp(5),
        fontWeight: "bold"
    },
    textH1: {
        color: "#000000",
        fontSize: fp(2),
        fontWeight: "bold"
    }    
})