import { StyleSheet, Text, View, Image } from 'react-native'
import React from 'react'
import { fp, hp, wp } from '../../helpers/Dimensions'
import Header from '../../components/Header'
import { CARWHITE, LOGO } from '../../assets/Icon'
import Buttonblack from '../../components/Buttonblack'
import { useNavigation } from '@react-navigation/native'


const Profilecompleted = () => {
    const navigation = useNavigation()

    return (
        <View style={styles.mainContainer}>
            <Header title="Profile Completed" link="Documents" />
            <View style={styles.imgContainer}>
                <Image source={LOGO} />
                <Image source={CARWHITE} />
            </View>
            <View style={styles.textContainer}>
                <Text style={styles.textH2}>Profile Creation Completed</Text>
            </View>
            <View style={styles.textContainer}>
                <Text style={styles.textNormal}>You will be notified within 24 hours as Admin will verify all details from your end.</Text>
            </View>
            <Buttonblack title="Got to Bank Details" wide="90" onPress={() => navigation.navigate("Bank")} />
        </View>
    )
}

export default Profilecompleted

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(50),
        justifyContent: "center",
        alignItems: "center"
    },
    textContainer: {
        backgroundColor: "#FFFFFF",
        width: wp(90),
        alignSelf: "center",
        paddingTop: 20,
        paddingBottom: 20
    },
    textH2: {
        fontSize: fp(2.5),
        fontWeight: "bold",
        color: "#000000",
        textAlign: "center"
        //paddingLeft: 5
    },
    textNormal: {
        fontSize: fp(2),
        color: "#000000"
    },


})