import { PermissionsAndroid, StyleSheet, Text, View, Image, TouchableOpacity, ActivityIndicator, Button } from 'react-native'
import React, { useEffect, useState, useRef  } from 'react'
import { hp, wp } from '../../helpers/Dimensions'
import Header from '../../components/Header'
import { LOGO, MAP, MAPROUTE } from '../../assets/Icon'
import { useNavigation } from '@react-navigation/native'
import MapView, { Marker, Polyline } from 'react-native-maps';
import MapViewDirections from 'react-native-maps-directions';
import Geolocation from 'react-native-geolocation-service';
import RideService, { trackRide, completeRide} from '../../services/RideService'
import { saveToStorage, getFromStorage } from '../../utils/storageHelper';

const GOOGLE_MAPS_APIKEY = "AIzaSyDZDczEIV69u0OyAG0B7FtJwQiTc5TzGj0";

//const source = { latitude: 28.6429485, longitude: 77.4075134 };
//const destination = { latitude: 28.6236153, longitude: 77.3666231};

const Ridetrack = () => {
    const mapRef = useRef(null);
    const [mLat, setMLat] = useState(null);
    const [mLong, setMLong] = useState(null);
    const [locationName, setLocationName] = useState("Fetching location...");
    const [loading, setLoading] = useState(true);
    const [rideInfo, setRideInfo] = useState(null);
    const [source, setSource] = useState(null);
    const [destination, setDestination] = useState(null);
    const [currentLocation, setCurrentLocation] = useState(source);
    const [rideCompleted, setRideCompleted] = useState(false);
    const [showCompleteButton, setShowCompleteButton] = useState(false);

    const navigation = useNavigation()

    

    useEffect(() => {

      /*
      let progress = 0;
    const interval = setInterval(() => {
      progress += 0.05;

      const newLat = source.latitude + (destination.latitude - source.latitude) * progress;
      const newLng = source.longitude + (destination.longitude - source.longitude) * progress;

      const newPosition = { latitude: newLat, longitude: newLng };

      setCurrentLocation(newPosition);
      const distance = getDistance(newPosition, destination);

      if (distance <= 50) {
        console.log("within50mtrs", distance);
        setShowCompleteButton(true);
        clearInterval(interval);
      }


      if (progress >= 1) clearInterval(interval);
    }, 2000);

    return () => clearInterval(interval);
    */


                requestLocationPermission();
                fetchRecentRide();
            }, [])

            function getDistance(coord1, coord2) {
              const toRad = value => (value * Math.PI) / 180;
              const R = 6371e3; // Radius of Earth in meters
              const dLat = toRad(coord2.latitude - coord1.latitude);
              const dLon = toRad(coord2.longitude - coord1.longitude);
              const lat1 = toRad(coord1.latitude);
              const lat2 = toRad(coord2.latitude);
          
              const a =
                Math.sin(dLat / 2) * Math.sin(dLat / 2) +
                Math.cos(lat1) * Math.cos(lat2) * Math.sin(dLon / 2) * Math.sin(dLon / 2);
              const c = 2 * Math.atan2(Math.sqrt(a), Math.sqrt(1 - a));
              return R * c; // Distance in meters
            }
        
        const requestLocationPermission = async () => {
                try {
                  const granted = await PermissionsAndroid.request(
                    PermissionsAndroid.PERMISSIONS.ACCESS_FINE_LOCATION,
                    {
                      title: 'Location Permission',
                      message:
                        'This app needs access to your location to show your position on the map.',
                      buttonNeutral: 'Ask Me Later',
                      buttonNegative: 'Cancel',
                      buttonPositive: 'OK',
                    },
                  );
                  if (granted === PermissionsAndroid.RESULTS.GRANTED) {
                    console.log("Location permission granted");
                    getLocation();
                  } else {
                    console.log('Location permission denied');
                    setLoading(false);
                  }
                } catch (err) {
                  console.warn(err);
                  setLoading(false);
                }
              };
        
              const getLocation = () => {
                Geolocation.getCurrentPosition(
                  (position) => {
                    console.log("your loc in ride track: ", position);
                    setMLat(position.coords.latitude);
                    setMLong(position.coords.longitude);
                    setLoading(false);
                  },
                  (error) => {
                    // See error code charts below.
                    console.log(error.code, error.message);
                    setLoading(false);
                  },
                  { enableHighAccuracy: true, timeout: 15000, maximumAge: 10000 }
              );
              }
        
              const storageRideId = async () => {
                try {
                    const rideId = await getFromStorage('rideId');
                    return rideId;
                } catch (error) {
                    console.error("Error fetching rideId:", error);
                    return null;
                }
            };
    
    
            const fetchRecentRide = async () => {
                const rideId = await storageRideId();
                //console.log("ridestorage in ride track screen: ", rideId);
                if(rideId){
                    const ride  = await trackRide(rideId);  
                    //console.log("RIDETRACK142: ", ride);
                    if(ride) {
                      //saveToStorage("lastScreen", "Ridestart");
                      var rideDtlObj = ride[0];
                      setRideInfo(rideDtlObj);
                      //console.log("lat====Parcel ", rideDtlObj?.pickup_latitude , rideDtlObj?.pickup_longitude, rideDtlObj?.delivery_latitude, rideDtlObj?.delivery_longitude);
                      const newSource = { 
                        latitude: parseFloat(rideDtlObj?.pickup_latitude), 
                        longitude: parseFloat(rideDtlObj?.pickup_longitude) 
                      };
                    
                    const newDestination = { 
                        latitude: parseFloat(rideDtlObj?.delivery_latitude), 
                        longitude: parseFloat(rideDtlObj?.delivery_longitude) 
                    };

                      //const newSource = { latitude: 28.6429485, longitude: 77.4075134 };
                      //const newDestination = { latitude: 28.6236153, longitude: 77.3666231};
                      setSource(newSource);
                      setDestination(newDestination);
                      setCurrentLocation(newSource);

                      //console.log("source=== ", newSource, "dest=== ", newDestination);
                      startRideTracking(newSource, newDestination);
                    }  
                }
            }

            const startRideTracking = (src, dest) => {
              let progress = 0;
              const interval = setInterval(() => {
                  progress += 0.05;
      
                  const newLat = src.latitude + (dest.latitude - src.latitude) * progress;
                  const newLng = src.longitude + (dest.longitude - src.longitude) * progress;
      
                  const newPosition = { latitude: newLat, longitude: newLng };
      
                  setCurrentLocation(newPosition);
                  const distance = getDistance(newPosition, dest);
      
                  if (distance <= 50) {
                      //console.log("Within 50 meters:", distance);
                      setShowCompleteButton(true);
                      clearInterval(interval);
                  }
      
                  if (progress >= 1) clearInterval(interval);
              }, 2000);
      
              return () => clearInterval(interval);
          }; 


          /*const startRideTracking = (polyline) => {
            let index = 0;
            
            const interval = setInterval(() => {
                if (index >= polyline.length - 1) {
                    clearInterval(interval);
                    return;
                }
        
                const newPosition = polyline[index];
                setCurrentLocation(newPosition);
                const distance = getDistance(newPosition, polyline[polyline.length - 1]); // Distance to destination
        
                if (distance <= 50) {
                    setShowCompleteButton(true);
                    clearInterval(interval);
                }
        
                index++;
            }, 2000);
        
            return () => clearInterval(interval);
        };*/
        

          if (!source || !destination) {
            return <Text>Loading ride data...</Text>;
        }

    const rideEndFunc = async () => {
      try {
            const rideId = await storageRideId();
            const completeRideInfo  = await completeRide(rideId);
            //console.log("completeRideInfo=== ", completeRideInfo);
            if(completeRideInfo){
              
              navigation.navigate("Payment");    
            }            
          } catch (error) {
            console.error("Error accepting ride:", error);
          }
    }

    if (loading) {
      return (
        <View style={{ flex: 1, justifyContent: "center", alignItems: "center" }}>
          <ActivityIndicator size="large" color="#0000ff" />
        </View>
      );
    }

    return (
        <View style={styles.mainContainer}>
            <Header title="Ride Track" link="Profile" />
            

            <MapView
        ref={mapRef}
        provider="google"
        style={{ flex: 1 }}
        initialRegion={{
          latitude: (source.latitude + destination.latitude) / 2,
          longitude: (source.longitude + destination.longitude) / 2,
          latitudeDelta: 0.05,
          longitudeDelta: 0.05,
        }}
        onMapReady={() => {
          if (mapRef.current) {
            mapRef.current.fitToCoordinates([source, destination], {
              edgePadding: { top: 50, right: 50, bottom: 50, left: 50 },
              animated: true,
            });
          }
        }}
      >
        <Marker coordinate={source} title="Pickup Location" pinColor="green" />
        <Marker coordinate={destination} title="Drop-off Location" pinColor="red" />

        <Marker coordinate={currentLocation} title="Moving Object" pinColor="blue" />

        <MapViewDirections
          origin={source}
          destination={destination}
          apikey={GOOGLE_MAPS_APIKEY}
          strokeWidth={5}
          strokeColor="blue"
        />
      </MapView>
            

            {showCompleteButton && (
        <View style={{ position: 'absolute', bottom: 50, left: 20, right: 20 }}>
          <Button title="Ride Complete" onPress={() => rideEndFunc()} />
        </View>
      )}
        </View>
    )
}

export default Ridetrack

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(20),
        justifyContent: "center",
        alignItems: "center"
    },
    map: {
      flex: 1,
  }
})