import { Image, KeyboardAvoidingView, Platform, ScrollView, StyleSheet, Text, TouchableOpacity, View } from 'react-native'
import React, { useState } from 'react'
import { CARWHITE, LOGO } from '../../assets/Icon'
import { fp, hp, wp } from '../../helpers/Dimensions'
import Textbox from '../../components/Textbox'
import Buttonblack from '../../components/Buttonblack'
import Header from '../../components/Header'
import { useNavigation } from '@react-navigation/native'
import Headerback from '../../components/Headerback'
import Toast from 'react-native-simple-toast';
import { saveToStorage } from '../../utils/storageHelper';
import { verifyOTP } from '../../services/LoginService'

const Verify = (props) => {
    const [otp, setOtp] = useState('1234');
    const navigation = useNavigation()

    const handleOtp = async () => {
        const mobile = props.route.params.mobile;
        var args = {}
        args['mobile']  = mobile;
        args['otp']     = otp;
        const verify_otp_response = await verifyOTP(args);
        
        if(verify_otp_response){
            saveToStorage("login_dtl", JSON.stringify(verify_otp_response.driver_obj));
            navigation.navigate("Dashboard");
        }
        
    }

    return (
        <KeyboardAvoidingView
              style={{ flex: 1 }}
              behavior={Platform.OS === 'ios' ? 'padding' : 'height'}
              keyboardVerticalOffset={Platform.OS === 'ios' ? 100 : 0}
            >
              <ScrollView
                contentContainerStyle={styles.container}
                keyboardShouldPersistTaps="handled"
              >
        <View style={styles.mainContainer}>
            <Headerback title="Verify" link="Login" />
            <View style={styles.imgContainer}>
                <Image source={LOGO} />
                <Image source={CARWHITE} />
            </View>
            <View style={styles.labelContainer}>
                <Text style={styles.textH2}>Verify mobile number</Text>
            </View>
            <View style={styles.textBoxContainer}>
                <Textbox 
                    title="OTP" 
                    wide="80"
                    val={otp}
                    changetext={(e) => {
                        const onlydigit = e.replace(/[^0-9]/g, '').slice(0.10);
                        setOtp(onlydigit)
                        }
                    }
                    keyboardType = "number-pad"
                />
            </View>
            <Buttonblack title="Verify" wide="90" onPress={handleOtp} />
            <View style={styles.resendCodeContainter}>
                <Text style={styles.textNormal}>Didn't receive sms?</Text>
                <TouchableOpacity>
                    <Text style={[styles.textNormal, { color: "orange" }]}>Resend Code</Text>
                </TouchableOpacity>
            </View>

        </View>
        </ScrollView>
            </KeyboardAvoidingView>
    )
}

export default Verify

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(52),
        justifyContent: "center",
        alignItems: "center"
    },
    labelContainer: {
        backgroundColor: "#FFFFFF",
        //height: hp(5),
        width: wp(90),
        alignSelf: "center"
    },
    textBoxContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(15),
        width: wp(90),
        alignItems: "center",
        flexDirection: "row",
        justifyContent: "space-evenly",
        alignSelf: "center"
    },
    resendCodeContainter: {
        backgroundColor: "#FFFFFF",
        width: wp(100),
        height: hp(5),
        flexDirection: "row",
        justifyContent: "space-evenly"
    },
    textH2: {
        fontSize: fp(2),
        fontWeight: "bold",
        color: "#000000",
        paddingLeft: 5
    },
    textNormal: {
        fontSize: fp(2),
        color: "#000000"
    },

})