import { BASE_URL } from '../../config';
import { StyleSheet, Text, View, Image, Button } from 'react-native'
import React, { useRef, useState } from 'react'
import { fp, hp, wp } from '../../helpers/Dimensions'
import { CARWHITE, LOGO } from '../../assets/Icon'
import Header from '../../components/Header'
import Buttonblack from '../../components/Buttonblack'
import Buttonwhite from '../../components/Buttonwhite'
import Textbox from '../../components/Textbox'
import Headerback from '../../components/Headerback'
import Toast from 'react-native-simple-toast';
import LoginService from "../../services/LoginService";
import { useTranslation } from 'react-i18next';
import '../../i18n';

const Login = ({ navigation }) => {
  const [mobile, setMobile] = useState("");
  const { t, i18n } = useTranslation();
  

  const handleLogin = () => {
      if (mobile.length === 10) {
          LoginService(mobile, navigation);
      } else {
        Toast.show('Mobile can not be empty');
      }
  };

    return (
        <View style={styles.mainContainer}>
            <Headerback title="Login" link="Welcome" />
            <View style={styles.imgContainer}>
                <Image source={LOGO} />
                <Image source={CARWHITE} />
            </View>
            <View style={styles.labelContainer}>
                <Text style={styles.textH2}>{t('enter_mobile')}</Text>
            </View>
            <View style={styles.textBoxContainer}>
                <Textbox title={t('mobile_number')} wide="90"
                    val={mobile}
                    changetext={(e) => setMobile(e)}
                />
            </View>
            <Buttonblack title="Login" wide="90" onPress={handleLogin} />
            <Button title="🇿🇦 Afrikaans" onPress={() => i18n.changeLanguage('af')} />
            <Button title="🇬🇧 English" onPress={() => i18n.changeLanguage('en')} />
            <Button title="🇮🇳 हिंदी" onPress={() => i18n.changeLanguage('hi')} />
            
        </View>

    )
}

export default Login

const styles = StyleSheet.create({
    mainContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(100),
        widht: wp(100)
    },
    imgContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(60),
        justifyContent: "center",
        alignItems: "center"
    },
    labelContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(5),
        width: wp(90),
        alignSelf: "center"
    },
    textBoxContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(10),
        alignItems: "center",
        padding: 5

    },
    crtAccContainer: {
        backgroundColor: "#FFFFFF",
        height: hp(40),
        justifyContent: "space-evenly",
        flexDirection: "row"
    },
    textH2: {
        fontSize: fp(2),
        fontWeight: "bold",
        color: "#000000",
        paddingLeft: 5
    },
    textNormal: {
        fontSize: fp(2),
        color: "#000000"
    },
    inpt: {
        width: wp(90),
        borderRadius: 15,
        borderWidth: 1,
        borderColor: "#223138",
        paddingHorizontal: 10
    }


})