<?php
namespace App\Http\Controllers\Api\Driver;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Drivers;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;
use Tymon\JWTAuth\Facades\JWTAuth;
use Illuminate\Support\Facades\Log;

class AuthController extends Controller
{

    public function sendOtpp(Request $request)
    {
        return apiResponse(1, 'OTP sent successfully. It is valid for 10 minutes.', [], 200);       
    }

    public function sendOtp(Request $request)
    {

        if (isUserAlreadyLoggedIn('driver')) {
        $user = Drivers::where('mobile', $request->mobile)
                            ->first();
        return apiResponse(1, 'Already logged in', $user, 200);
        }

        $validator = Validator::make($request->all(), [
            'mobile' => 'required|digits:10',
        ]);

        if ($validator->fails()) {
			$messages = $validator->errors()->all();
			return apiResponse(0, $messages[0], '', 422);
        }

        $mobile = $request->mobile;
        $otp = rand(1000, 9999);
	    $otp = 1234;	

        Drivers::updateOrCreate(
            ['mobile' => $mobile],
            ['status' => '1', 'otp' => $otp, 'otp_expires_at' => Carbon::now()->addMinutes(10)]

        );

        $api_data = [];
        $api_data['otp'] = $otp;

		return apiResponse(1, 'OTP sent successfully. It is valid for 10 minutes.', $api_data, 200);	
        
    }

    public function verifyOtp(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'mobile' => 'required|digits:10',
            'otp' => 'required|digits:4',
        ]);

        if ($validator->fails()) {
			$messages = $validator->errors()->all();
            return apiResponse(0, $messages[0], '', 422);
        }

        \Log::info("verifyotpchk:", [$request->mobile]); 

        $driver = Drivers::where('mobile', $request->mobile)
                            ->where('otp', $request->otp)
                            //->where('otp_expires_at', '>', Carbon::now())
                            ->first();

        if (!$driver) {
			return apiResponse(0, 'Invalid OTP or OTP has expired.', '', 400);
        }

        // Generate JWT token
        //$token = JWTAuth::fromUser($driver);

        // Clear the used OTP
        //$driver->update(['otp' => null, 'otp_expires_at' => null]);
        
		$details = [
                'mobile'        => $driver->mobile,
                'login_id'      => $driver->id,
                'logged_in'     => TRUE

        ];
        $request->session()->put('driver', $details);

		$api_data = [];
		//$api_data['token'] = $token;
		$api_data['mobile']= $driver->mobile;
		$api_data['status']= $driver->status;
		$api_data['verified']= $driver->verified;
        $api_data['driver_obj']   = $driver;

		return apiResponse(1, 'OTP Matched', $api_data, 200);
    }

    public function logout(Request $request)
    {
        $request->session()->forget('driver');

        return apiResponse(1, 'logout Successfully.', [], 200); 

    }


}//
