<?php
namespace App\Http\Controllers\Api\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Users;
use Illuminate\Support\Facades\Validator;
use Carbon\Carbon;

class AuthController extends Controller
{
    public function sendOtp(Request $request)
    {
        if (isUserAlreadyLoggedIn('user')) {
        $user = Users::where('mobile', $request->mobile)
                            ->first();
        return apiResponse(2, 'Already logged in', $user, 200);
        }

        $validator = Validator::make($request->all(), [
            'mobile' => 'required|digits:10',
        ]); 

        if($validator->fails()) {
            $messages = $validator->errors()->all();
            return apiResponse(0, $messages[0], '', 422);
        }
       
        $mobile = $request->mobile;
        $otp = rand(1000, 9999);
        $otp = 1234; 

        Users::updateOrCreate(
            ['mobile'   => $mobile],
            ['status' => '1', 'otp' => $otp]
        );

        $api_data = [];
        $api_data['otp'] = $otp;

		return apiResponse(1, 'OTP sent successfully.', $api_data, 200);  
    }

    public function verifyOtp(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'mobile' => 'required|digits:10',
            'otp' => 'required|digits:4',
        ]);

        if ($validator->fails()) {
			$messages = $validator->errors()->all();
            return apiResponse(0, $messages[0], '', 422);
        }

        $user = Users::where('mobile', $request->mobile)
                            ->where('otp', $request->otp)
                            //->where('otp_expires_at', '>', Carbon::now())
                            ->first();

        if(!$user){
			return apiResponse(0, 'Invalid OTP or OTP has expired.', '', 400);
        }
        
		$details = [
                'mobile'        => $user->mobile,
                'login_id'      => $user->id,
                'logged_in'     => TRUE

        ];
        $request->session()->put('user', $details);

        $user->photo_url = isset($user->photo) ? asset('storage/'.$user->photo) : defaultProfilePic();
		$api_data = [];
		$api_data['mobile']     = $user->mobile;
		$api_data['user_obj']   = $user;
		$api_data['status']     = $user->status;

		return apiResponse(1, 'OTP Matched', $api_data, 200);
    }

    public function chkSession()
    {
        if (isUserAlreadyLoggedIn('user')) {
            $sessionUser = request()->session()->get('user');
            $user = Users::where('id', $sessionUser['login_id'])->first();      
            $user->photo_url = isset($user->photo) ? asset('storage/'.$user->photo) : defaultProfilePic();
            return apiResponse(2, 'Already logged in', $user, 200);
        } else {
            return apiResponse(0, 'Not logged in', [], 200);
        }       
    }

    public function logout(Request $request)
    {
        $request->session()->forget('user');
        // $request->session()->invalidate();

        return apiResponse(1, 'logout', [], 200); 

    }

}

