<?php

namespace App\Http\Middleware\Admin;

use Closure;
use Illuminate\Http\Request;

class redirectAdminHome
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next)
    {
        $TYPE = 'admin';
        if (app()->request->session()->has($TYPE)) {
            $session_obj = app()->request->session()->get($TYPE);
            $logged_in = $session_obj['logged_in'];
            if($request->ajax()){
                return response()->json([
                        'status' => '1',
                        'message' => 'Already Login',
                        'data'    => array(),
                ]);
            }
            return redirect()->route('admin.dashboard');
        }

        return $next($request);
    }
}
