<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Exception;
use Illuminate\Support\Facades\Log;

class EnsureUserIsAuthenticated
{
    public function handle($request, Closure $next)
    {
        if(!app()->request->session()->has('user'))
        return apiResponse('0', 'Login Required', [], 401);
        
        $request->merge(['user_login' => $request->session()->get('user')]);

        return $next($request);
    }
}
