<?php
namespace App\Http\Requests;
use Illuminate\Foundation\Http\FormRequest;

class ParcelRequst extends FormRequest
{
    public function authorize()
    {
       return true; 
    } 

    public function rules()
    {
        $rules = [];
        $routeName = $this->route()->getName();
        switch($routeName){

            case 'parcels.get':
            return $this->getParcels();

            case 'parcels.create':
            return $this->createParcels();

            case 'parcels.cancel_by_user':
            return $this->cancelByUserParcel();

            case 'parcels.pending':
            return $this->pendingNearByParcels();    

            case 'parcels.on_the_way':
            return $this->onTheWay();


            case 'parcels.accept':
            return $this->acceptParcelRules();

            case 'parcels.reject':
            return $this->rejectParcelRules();

            case 'parcels.cancel':
            return $this->cancelParcelRules(); 

            case 'parcels.summary':
            return $this->parcelSummaryRules(); 

            case 'parcels.pickup':
            return $this->pickupParcelRules();

            case 'parcels.payment':
            return $this->ridePaymentRules();

            case 'parcels.payment_success':
            return $this->ridePaymentRules();

            case 'parcels.payment_fare':
            return $this->ridePaymentFareRules();


            case 'parcels.deliver':
            return $this->deliverParcelRules();

            case 'parcels.apply_coupon':
            return $this->applyCouponRules();

            case 'parcels.single_mode':
            return $this->singleModeRules();

            case 'parcels.payment_received':
            return $this->paymentReceived();

            case 'parcels.ride_start':
            return $this->rideStart();

            case 'parcels.vehicle_option':
            return $this->vehicleOption();

            case 'parcels.feedback':
            return $this->feedbackRules();

        }
    }

    protected function getParcels()
    {
        return [
            'parcel_id' => 'nullable|integer',
        ];
    }

    protected function cancelByUserParcel()
    {
        return [
            'ride_id'   => 'required|integer',
            'reason'    => 'required|integer',
        ];
    }

    protected function onTheWay()
    {
        return [
            'parcel_id' => 'required|integer',
        ];
    }

    protected function rideStart()
    {
        return [
            'parcel_id' => 'nullable|integer',
        ];
    }

    protected function paymentReceived()
    {
        return [
            'parcel_id' => 'required|integer',
        ];
    }

    protected function createParcels()
    {
        return [
            'parcel_type'               => 'required|numeric|max:255',
            'pickup_address'            => 'required|string',
            'pickup_latitude'           => 'required|numeric|between:-90,90',
            'pickup_longitude'          => 'required|numeric|between:-180,180',
            'pickup_complete_address'   => 'nullable|string',
            'delivery_address'          => 'required|string',
            'delivery_latitude'         => 'required|numeric|between:-90,90',
            'delivery_longitude'        => 'required|numeric|between:-180,180',
            'delivery_complete_address' => 'nullable|string',
            'weight'                    => 'nullable|numeric',
            'weight_type'               => 'nullable|numeric',
            'contact_name'              => 'nullable|string',
            'contact_mobile'            => 'nullable|string',
            'schedule_ride'             => 'nullable|string',
            //'distance'          => 'nullable|numeric',
            'vehicle_id'                => 'nullable|numeric',
            'coupon_id'                 => 'nullable|numeric',
            'final_price'               => 'nullable|string',
        ];
    }

    protected function pendingNearByParcels()
    {
        return [
            'status' => 'nullable|string',
            'latitude' => 'nullable|numeric',
            'longitude' => 'nullable|numeric',
            'radius' => 'nullable|numeric|min:0', 
        ];
    }

    protected function acceptParcelRules()
    {
        return [
            'parcel_id' => 'required|numeric',
        ];
    }

    protected function rejectParcelRules()
    {
        return [
            'parcel_id' => 'required|numeric',
        ];
    }

    protected function cancelParcelRules()
    {
        return [
            'parcel_id' => 'required|numeric',
            'reason'    => 'required|numeric',
        ];
    }

    protected function parcelSummaryRules()
    {
        return [
            'parcel_id' => 'required|numeric',
        ];
    }

    protected function pickupParcelRules()
    {
        return [
            'parcel_id' => 'required|numeric',
            'otp'       => 'required|numeric',
        ];
    }

    protected function ridePaymentRules()
    {
        return [
            'parcel_id' => 'required|numeric',
        ];
    }

    protected function ridePaymentFareRules()
    {
        return [
            'parcel_id' => 'required|numeric',
        ];
    }

    protected function deliverParcelRules()
    {
        return [
            'parcel_id' => 'required|numeric',
            //'otp'       => 'required|numeric', //comment for the timing 2025-03-25
        ];
    }

    protected function applyCouponRules()
    {
        return [
            'original_price'    => 'required|numeric',
            'coupon_id'         => 'required|numeric',
        ];
    }

    protected function singleModeRules()
    {
        return [
            'parcel_type'       => 'required|string|max:255',
            'pickup_address'    => 'required|string|max:255',
            'pickup_latitude'   => 'required|string|max:255',
            'pickup_longitude'  => 'required|string|min:0',
            'delivery_address'  => 'required|string|min:0',
            'delivery_latitude' => 'required|string|min:0',
            'delivery_longitude'=> 'required|string|min:0',
            'weight'            => 'nullable|numeric|min:0',
            'weight_type'       => 'nullable|numeric|min:0',
            'vehicle_id'        => 'nullable|numeric',
            'description'       => 'nullable|string|min:0',
            'user_id'           => 'nullable|numeric|min:0',
            'distance'          => 'nullable|numeric|min:0',
            'payment'           => 'nullable|numeric|min:0',
            'commission'        => 'nullable|numeric|min:0'
        ];
    }

    protected function vehicleOption()
    {
        return [
            'pickup_latitude'   => 'required|numeric|max:255',
            'pickup_longitude'  => 'required|numeric|max:255',
            'delivery_latitude' => 'required|numeric|max:255',
            'delivery_longitude'=> 'required|numeric|max:255',
        ];
    }

    protected function feedbackRules()
    {
        return [
            'rating'    => 'required',
            'message'   => 'nullable'
        ];
    }

    protected function failedValidation(\Illuminate\Contracts\Validation\Validator $validator)
    {
        $errors = $validator->errors()->all();
        $response = response()->json([
            'status' => '0',
            'message' => 'Validation errors occurred.',
            'errors' => $errors
        ], 422);
        

        throw new \Illuminate\Validation\ValidationException($validator, $response);
    }  
}
