<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use App\Models\Users;
use App\Models\Drivers;


class Parcels extends Model
{
    use HasFactory;

	protected $table = 'parcels';

	protected $fillable = [
        'user_id',
        'parcel_type',
        'description',
        'weight',
        'weight_type',
        'vehicle_id',
        'value',
        'pickup_address',
        'pickup_latitude',
        'pickup_longitude',
        'pickup_complete_address',
        'pickup_time_window_start',
        'pickup_time_window_end',
        'delivery_address',
        'delivery_latitude',
        'delivery_longitude',
        'delivery_complete_address',
        'delivery_time_window_start',
        'delivery_time_window_end',
        'contact_name',
        'contact_mobile',
        'schedule_ride',
        'status',
        'driver_id',
        'assigned_time',
        'pickup_time',
        'delivery_time',
        'distance',
        'travel_time',
        'payment',    
        'coupon_id',
        'discount_price',    
        'final_price',    
        'payment_type',
        'commission',
        'tax',
    ];

	protected $casts = [
        'pickup_time_window_start'	=> 'datetime',
        'pickup_time_window_end' 	=> 'datetime',
        'delivery_time_window_start'=> 'datetime',
        'delivery_time_window_end' 	=> 'datetime',
        'assigned_time' 			=> 'datetime',
        'pickup_time' 				=> 'datetime',
        'delivery_time' 			=> 'datetime',
    ];

    protected $appends = ['currency_icon', 'status_name', 'ride_type', 'screen_name', 'screen_name_user'];
	
    public function user()
    {
        return $this->belongsTo(Users::class, 'user_id');
    }

    public function driver()
    {
        return $this->belongsTo(Drivers::class, 'driver_id');
    }


    public function getCurrencyIconAttribute()
    {
        return currency_icon();
    }

    public function getStatusNameAttribute()
    {
        return statusName($this->status);
    }

    public function getRideTypeAttribute()
    {
        return ride_type($this->parcel_type);
    }

    public function getScreenNameAttribute()
    {
        return getScreenName($this->status);
    }

    public function getScreenNameUserAttribute()
    {
        return ScreenNameForUser($this->status);
    }

}
