<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
//use Illuminate\Database\Eloquent\Relations\HasMany;
use Carbon\Carbon;

class Users extends Model
{
    use HasFactory;
    protected $table = 'users';

    protected $fillable = [
        'name',
        'email',
        'mobile',
        'address',
        'otp',
        'emergency_number',
        'photo',
        'emergency_name',
        'emergency_message'
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    protected $appends = ['photo_url'];

    // Accessor for the 'created_at' attribute
    public function getCreatedAtAttribute($value)
    {
        return Carbon::parse($value)->format('Y-m-d H:i:s');
    }

    // Accessor for the 'updated_at' attribute
    public function getUpdatedAtAttribute($value)
    {
        return Carbon::parse($value)->format('Y-m-d H:i:s');
    }

    public function get_data_table($client_id = NULL)
    {
        $data = Users::whereIn('status', ['0','1'])
               ->orderBy('name')
               ->take(10)
               ->get();
        return $data;
    }
    
    public function count_all()
    {
        $count =  Users::count();
        return $count;
    }

    public function getPhotoUrlAttribute()
    {
        return url('storage/' . $this->photo);
    }
}
