<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Tymon\JWTAuth\Contracts\JWTSubject;


class Drivers extends Authenticatable implements JWTSubject
{
    use HasFactory;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'drivers';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'fname',
        'lname',
        'gender',
        'email',
        'mobile',
        'otp',
        'otp_expires_at',
        'location',
        'profile_photo',
        'category',
        'model',
        'brand',
        'year_of_manufacture',
        'registration_number',
        'vehicle_insurance',
        'vehicle_type',
        'vehicle_color',
        'vehicle_photo',
        'adhar',
        'driving_licence',
        'registration_certificate',
        'availability',
        'status'
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // Accessor for the 'created_at' attribute
    public function getCreatedAtAttribute($value)
    {
        return Carbon::parse($value)->format('Y-m-d H:i:s');
    }

    // Accessor for the 'updated_at' attribute
    public function getUpdatedAtAttribute($value)
    {
        return Carbon::parse($value)->format('Y-m-d H:i:s');
    }

    public function get_data_table($client_id = NULL)
    {
        $data = Drivers::where('status', '1')
               ->orderBy('fname')
               ->take(10)
               ->get();
        return $data;
    }
    
    public function count_all()
    {
        $count =  Driver::count();
        return $count;
    }

    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
        return [
            'mobile' => $this->mobile,
        ];
    }
}
