@extends('admin.layouts.main')
@section('main.container')
<link href="/taxi/assets/vendor/clockpicker/css/bootstrap-clockpicker.min.css" rel="stylesheet">
<script src="/taxi/assets/vendor/clockpicker/js/bootstrap-clockpicker.min.js"></script>
<style>
    .overlay-container {
        position: relative;
        display: inline-block;
    }

    .overlay-container img.overlay-image {
        display: none;
        position: absolute;
        top: 0;
        left: 0;
        z-index: 10;
        width: 200px; /* Adjust the width as needed */
        height: auto;
    }

    .overlay-container:hover img.overlay-image {
        display: block;
    }
</style>
<div class="content-body">
    <!-- row -->
    <div class="container-fluid">
        <!-- Row -->
        <div class="row">
            <!-- Column starts -->
            <div class="col-xl-12">
                <div class="card" id="accordion-five">
                    <div class="card-header flex-wrap d-flex justify-content-between px-3">
                        <div>
                            <h4 class="card-title">Rating</h4>
                            <p class="m-0 subtitle">Note: Please arrange Rating</p>
                        </div>
                        <ul class="nav nav-tabs dzm-tabs" id="myTab-4" role="tablist">
                            <li class="nav-item" role="presentation">
                            </li>
                        </ul>
                    </div>
                    <div class="card-body p-0">
                        <div class="table-responsive">
                            <table id="table" class="display table" style="min-width: 845px">
                                <thead>
                                    <tr>
                                        <th>Trip ID</th>
                                        <th>Driver Name/Mobile/Email</th>
                                        <th>User Name/Email/Mobile</th>
                                        <th>Rating to Driver</th>
                                        <th>Rating to User</th>
                                        <th>Date</th>
                                    </tr>
                                    <tr>
                                        <td><input type="text" placeholder="Trip ID" size="10" class="input-fw"/></td>
                                        <td><input type="text" placeholder="Driver" size="10" class="input-fw"/></td>
                                        <td><input type="text" placeholder="User" size="10" class="input-fw"/></td>
                                        <td></td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                </thead>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Column ends -->
    </div>
</div>

<!------- MODAL ------->
<div class="modal right fade" id="myModel" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-center modal-xl" style="width:100%;">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="exampleModalLabel">Rating</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form role="form" id="myForm" autocomplete="off" enctype='multipart/form-data' class="parsley-validate" data-validate="parsley">
            <div class="modal-body">
                <div class="row">
                    <div class="col-12">
                        <!--This Part is removed it is only here for my ref -->
                        <div class="row">
                            <div class="col-12">
                                <div class="card mb-0">
                                    <div class="card-header p-1">
                                        <h4 class="card-title">General Info</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Name</label>
                                                <input type="text" class="form-control" id="name" name="name" placeholder="Name">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="weight_unit" class="form-label mb-2">Weight Unit</label>
                                                <select class="select-single form-control wide" name="weight_unit" data-placeholder="Weight Unit" style="width:200px;" data-parsley-required="true" data-parsley-errors-container="#weight_unit_error">
                                                    <option></option>
                                                    <?php if($weight_unit){ foreach($weight_unit as $id => $name){ ?>
                                                    <option value="<?= $id ?>"><?= $name ?></option>
                                                    <?php }} ?>
                                                </select>
                                                <div id="weight_unit_error"></div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-header p-1">
                                        <h4 class="card-title">Fare Info</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Weight Included In The Base Fare</label>
                                                <input type="text" class="form-control numeric" id="weight_included_in_the_base_fare" name="weight_included_in_the_base_fare" placeholder="Weight Included In The Base Fare" data-parsley-required="true" data-parsley-type="digits" maxlength="3">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Base Fare</label>
                                                <input type="text" class="form-control unsigned_float" id="base_fare" name="base_fare" placeholder="Base Fare" data-parsley-required="true">
                                            </div>
                                            <div class="mb-3 col-4">
                                                <label for="name" class="form-label mb-2">Fare For Extra Weight</label>
                                                <input type="text" class="form-control unsigned_float" id="fare_per_for_extra_weight" name="fare_per_for_extra_weight" placeholder="Fare For Extra Weight" data-parsley-required="true">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="card-header p-1">
                                        <h4 class="card-title">Basic Info</h4>
                                    </div>
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="mb-3 col-4">
                                                <label for="photo" class="form-label">Photo</label>
                                                <input class="form-control form-control-sm file_upload" name="photo" id="photo" type="file">
                                                <ul class="d-flex w-100 border-bottom pb-1 mb-1 fs-6">
                                                    <li class="w-75">
                                                        <div class="overlay-container">
                                                            <a href="javascript:void(0);">
                                                                Hover over me
                                                            </a>
                                                            <img src="" name="photo_img" id="photo_img" alt="Overlay Image" class="overlay-image">
                                                        </div>
                                                    </li>
                                                </ul>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary save">Save</button>
           </div>
           </form>
        </div>
    </div>
</div>
<script>
$('.clockpicker').clockpicker({
    placement: 'top',
    donetext: 'Done',
    autoclose: true,
}).find('input').change(function () {
    console.log(this.value);
});

$(document).on('change','.select-single',function(e){
    $(this).parsley().validate();
    if ($(this).parsley().isValid()){
        $(this).find('~ .select2-container .select2-selection--single').removeAttr('style');
    }
});

$(function(){
    $('.select-single').select2({
        dropdownParent: $('#myModel')
    });
});

var table;
$( document ).ready(function() {
    dataTable();
});

function dataTable()
{
    var postData = {'name': 'neeraj'};
    table = $('#table').DataTable({
        pageLength:100,
        paging:true,
        select: false,
        ordering: false,
        info: true,         
        lengthChange:false ,
        language: {
            paginate: {
              next: '<i class="fa-solid fa-angle-right"></i>',
              previous: '<i class="fa-solid fa-angle-left"></i>' 
            }
        },
        "ajax": {
            "url": "/<?= $TYPE ?>/rating/index_ajax_rating_list",
            "type": "POST",
            data: postData,
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
        },
        "initComplete": function(settings, json) {
            //js_switch();
        },
        "columns": [
           {data: "trip_id"},
           {data: "driver"},
           {data: "users"},
           {data: "rating_driver"},
           {data: "rating_user"},
           {data: "created_at"},
           //{data: "id"},
        ]
    });

   $("#table thead input").on('keyup change', function(e) {
        if (e.keyCode == 13 || e.keyCode == undefined || this.value == '') {
            table
                .column($(this).parent().index() + ':visible')
                .search(this.value)
                .draw();
        }
   });
   $('#table_filter').hide();
}

$(document).on('click','.disable',function(e){
    e.preventDefault();
    var row = $(this).parent().data('object');
    var id = row.id;
    var postData = new FormData()
    postData.append('api', '1');
    postData.append('id', id);
    $.ajax({
        type: 'POST',
        url:  "/<?= $TYPE ?>/client/disable",
        data: postData,
        contentType: false,
        cache: false,
        processData:false,
        beforeSend: function() {
             //$('.as_loader').addClass('show');
        },
        success: function(response){
            if(response.status == '1') {
                table.ajax.reload();
                $.notify(response.message, {type: 'success',align:"center", verticalAlign:"top", close: true});
            }else{
                $.notify(response.message, {type: 'warning',align:"center", verticalAlign:"top", close: true});
            }
            //$('.as_loader').removeClass('show');
        },
        error: function (error) {
            //$('.as_loader').removeClass('show');
        }
    });
});

$(document).on('click','.enable',function(e){
    e.preventDefault();
    var row = $(this).parent().data('object');
    var id = row.id;
    var postData = new FormData()
    postData.append('api', '1');
    postData.append('id', id);
    $.ajax({
        type: 'POST',
        url:  "/<?= $TYPE ?>/client/enable",
        data: postData,
        contentType: false,
        cache: false,
        processData:false,
        beforeSend: function() {
             //$('.as_loader').addClass('show');
        },
        success: function(response){
            if(response.status == '1') {
                table.ajax.reload();
                $.notify(response.message, {type: 'success',align:"center", verticalAlign:"top", close: true});
            }else{
                $.notify(response.message, {type: 'warning',align:"center", verticalAlign:"top", close: true});
            }
            //$('.as_loader').removeClass('show');
        },
        error: function (error) {
            //$('.as_loader').removeClass('show');
        }
    });
});

$(document).on('click','.add_new',function(e){
    e.preventDefault();
    $('.add_more,.save').show();
    $('.parsley-validate').parsley().destroy(); 
    $('.select2-selection--single').removeAttr('style');
    $('#myForm').find('input[name="id"]').remove();
    $('.overlay-container').hide();
    $(".file_upload").val("");
    setTimeout(function() {
        $('.select-single').trigger('change.select2');
    }, 100);
    $('#myForm')[0].reset();
    $('#myModel').modal('toggle');
});

$(document).on('click','.edit',function(e){
    e.preventDefault();
    $('.parsley-validate').parsley().destroy(); 
    $('#myForm').find('input[name="id"]').remove();
    $(".file_upload").val("");

    var row = $(this).parent().data('object');
    var id = row.id;
    fillForm(row);
    $('img[name="photo_img"]').parent().hide();
    if(row.photo_img){
        $('img[name="photo_img"]').parent().show();
        $('img[name="photo_img"]').attr('src', row.photo_img);
    }
    var cnt = row.no_of_licence;
    var hiddenInput = $('<input>').attr({
      type: 'hidden',
      name: 'id',
      id: 'id',
      value: id
    });
    $('#myForm').append(hiddenInput);
    $('#myModel').modal('toggle');
});

$(document).on('click','.save',function(e){
    e.preventDefault();
    $('.parsley-validate').parsley().validate();
    if ($('.parsley-validate').parsley().isValid()){
        var postData = new FormData()
        postData = getFormValues(postData);
        $.ajax({
            type: 'POST',
            url:  "/<?= $TYPE ?>/rating/save",
            data: postData,
            headers: {'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')},
            dataTyte: 'json',
            enctype: 'multipart/form-data',
            contentType: false,
            cache: false,
            processData:false,
            beforeSend: function() {
                 //$('.as_loader').addClass('show');
            },
            success: function(response){
                if(response.status == '1') {
                    table.ajax.reload();
                    $('#myModel').modal('toggle');
                    $.notify(response.message, {type: 'success',align:"center", verticalAlign:"top", close: true});
                }else{
                    $.notify(response.message, {type: 'warning',align:"center", verticalAlign:"top", close: true});
                }
                //$('.as_loader').removeClass('show');
            },
            error: function (error) {
                //$('.as_loader').removeClass('show');
            }
        });
    }
});
</script>
@endsection
