<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ApiController;
use App\Http\Controllers\Api\Driver\AuthController as DriverAuthController;
use App\Http\Controllers\Api\CustomerController;
use App\Http\Controllers\Api\Driver\Profile;
use App\Http\Controllers\Api\Driver\BankDetailController;
use App\Http\Controllers\Api\Driver\ParcelController;
use App\Http\Controllers\Api\Driver\RatingController;
use App\Http\Controllers\Api\Driver\IncidentController;

use App\Http\Controllers\Api\User\AuthController as UserAuthController;
use App\Http\Controllers\Api\User\ProfileController;
use App\Http\Controllers\Api\User\HomeController;
use App\Http\Controllers\Api\User\ParcelController as UserParcelController;

use App\Http\Controllers\Api\User\VehicleController;
use App\Http\Controllers\Api\User\RideController;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

///////////////////////
Route::middleware(['web'])->group(function () {
Route::post('/send-otp',                                [DriverAuthController::class, 'sendOtp']);
Route::post('/verify-otp',                              [DriverAuthController::class, 'verifyOtp']);


Route::middleware('auth.custom')->get('/logout',         [DriverAuthController::class, 'logout']);
Route::middleware('auth.custom')->get('/profile',       [Profile::class, 'driver_profile']);
Route::middleware('auth.custom')->post('/is-online',    [Profile::class, 'isOnline']);

Route::get('/ride-latest',                              [ParcelController::class, 'checkNewParcel']);
Route::middleware('auth.custom')->post('/ride-pending',   [ParcelController::class, 'getNearbyParcels'])->name('parcels.pending');
Route::middleware('auth.custom')->post('/ride-accept',    [ParcelController::class, 'acceptParcel'])->name('parcels.accept');
Route::middleware('auth.custom')->post('/ride-after-accept', [ParcelController::class, 'acceptAfterParcel']);
Route::middleware('auth.custom')->get('/ride-inprocess',     [ParcelController::class, 'inProcessParcel']);
Route::middleware('auth.custom')->post('/ride-arrived-pickup-loc',     [ParcelController::class, 'ArrivedPickupLocation']);
Route::middleware('auth.custom')->post('/driver-on-the-way',    [ParcelController::class, 'driverOnTheWay'])->name('parcels.on_the_way');
Route::middleware('auth.custom')->post('/otp-verify',           [ParcelController::class, 'otpVerify']);
Route::middleware('auth.custom')->post('/ride-start',       [ParcelController::class, 'startParcel']);
Route::middleware('auth.custom')->post('/ride-start-new',   [ParcelController::class, 'startParcelNew']);
Route::middleware('auth.custom')->post('/ride-track',       [ParcelController::class, 'trackParcel']);
Route::middleware('auth.custom')->post('/ride-reject',    [ParcelController::class, 'rejectParcel'])->name('parcels.reject');
Route::middleware('auth.custom')->post('/ride-cancel',    [ParcelController::class, 'cancelParcel'])->name('parcels.cancel');
Route::middleware('auth.custom')->post('/ride-summary',   [ParcelController::class, 'parcelSummary'])->name('parcels.summary');
Route::middleware('auth.custom')->post('/ride-pickup',    [ParcelController::class, 'pickupParcel'])->name('parcels.pickup');
Route::middleware('auth.custom')->post('/ride-payment-initiated',   [ParcelController::class, 'ridePaymentInitiated'])->name('parcels.payment');
Route::middleware('auth.custom')->post('/ride-payment-initiate-fare',   [ParcelController::class, 'ridePaymentInitiateFare'])->name('parcels.payment_fare');
Route::middleware('auth.custom')->post('/ride-deliver',   [ParcelController::class, 'deliverParcel'])->name('parcels.deliver');
Route::middleware('auth.custom')->post('/ride-history',   [ParcelController::class, 'historyParcel'])->name('parcels.history');
Route::middleware('auth.custom')->post('/single-mode',  [ParcelController::class, 'singleMode'])->name('parcels.single_mode');
Route::middleware('auth.custom')->get('cancel-reason',  [ParcelController::class,'cancelReason']);
Route::middleware('auth.custom')->post('/payment-received', [ParcelController::class, 'paymentReceived'])->name('parcels.payment_received');
Route::middleware('auth.custom')->get('/dashboard-stats',    [ParcelController::class, 'dashboardStats']);
Route::middleware('auth.custom')->post('/feedback',     [ParcelController::class, 'feedbackForUser'])->name('parcels.feedback');

Route::middleware('auth.custom')->post('/rating',       [RatingController::class, 'store']);
Route::middleware('auth.custom')->post('/incident',       [IncidentController::class, 'store']);



Route::middleware('auth.custom')->post('/update-profile',   [Profile::class, 'updateProfile']);
Route::middleware('auth.custom')->post('/upload-dl', 	    [Profile::class, 'uploadDL'])->name('drivers.update.DL');;
Route::middleware('auth.custom')->post('/upload-rc', 	    [Profile::class, 'uploadRC'])->name('drivers.update.RC');;
Route::middleware('auth.custom')->post('/upload-insurance', [Profile::class, 'uploadInsurance'])->name('drivers.update.Insurance');;
Route::middleware('auth.custom')->post('/vehicle',          [Profile::class, 'updateVehicleInfo'])->name('drivers.update.updateVehicleInfo');
Route::middleware('auth.custom')->get('/vehicle',           [Profile::class, 'vehicleInfo']);
Route::middleware('auth.custom')->get('/vehicle-type-dropdown',[Profile::class, 'vehicleTypeDropdown']);
Route::middleware('auth.custom')->post('/upload',           [Profile::class, 'upload']);
Route::middleware('auth.custom')->post('/updatec',          [Profile::class, 'updatec']);
Route::middleware('auth.custom')->post('/earning',          [Profile::class, 'earning']);
Route::middleware('auth.custom')->get('/legal-content',     [Profile::class, 'legalContent']);
Route::middleware('auth.custom')->get('/terms-condition',   [Profile::class, 'terms']);
Route::middleware('auth.custom')->post('/terms-verify',     [Profile::class, 'termsVerify'])->name('profile.terms');
Route::middleware('auth.custom')->post('/legal-verify',     [Profile::class, 'leagalVerify'])->name('profile.legal');
Route::middleware('auth.custom')->get('/privacy-policy',    [Profile::class, 'privacyPolicy']);
Route::middleware('auth.custom')->post('/profile-complete', [Profile::class, 'profileComplate'])->name('profile.complete');


Route::middleware('auth.custom')->post('/bank-details',     [BankDetailController::class, 'store']);
Route::middleware('auth.custom')->get('/bank-details',      [BankDetailController::class, 'getBankDetail']);

//////////////// USER /////////////////////

Route::post('user/send-otp',                                    [UserAuthController::class, 'sendOtp']);
Route::post('user/verify-otp',                                  [UserAuthController::class, 'verifyOtp']);
Route::post('user/logout',                                      [UserAuthController::class, 'logout']);
Route::get('user/chk-session',                                  [UserAuthController::class, 'chkSession']);

Route::middleware('auth.customUser')->post('user/profile',      [ProfileController::class, 'update']);
Route::middleware('auth.customUser')->get('user/profile',       [ProfileController::class, 'show']);
Route::middleware('auth.customUser')->post('user/profile-get',  [ProfileController::class, 'show']);
Route::middleware('auth.customUser')->get('user/is-profile-complete',  [ProfileController::class, 'profileComplete']);

Route::middleware('auth.customUser')->get('user/static-data',   [HomeController::class, 'staticData']);
Route::middleware('auth.customUser')->get('user/recent-ride',  [UserParcelController::class, 'recentRide']);
Route::middleware('auth.customUser')->post('user/parcel',       [UserParcelController::class, 'store'])->name('parcels.create');
Route::middleware('auth.customUser')->post('user/ride-cancel',  [UserParcelController::class, 'cancelParcel'])->name('parcels.cancel_by_user');
Route::middleware('auth.customUser')->get('user/get-parcel/{parcel_id}', [UserParcelController::class, 'show'])->name('parcels.get');
Route::get('user/is-ride-accept',                               [UserParcelController::class, 'isParcelAccept']);
Route::middleware('auth.customUser')->get('user/ride-inprocess',[UserParcelController::class, 'inProcessRide']);
Route::middleware('auth.customUser')->post('user/ride-start',   [UserParcelController::class, 'rideStartStatus'])->name('parcels.ride_start');
Route::middleware('auth.customUser')->get('user/coupon',        [UserParcelController::class, 'couponList']);
Route::middleware('auth.customUser')->post('user/apply-coupon',  [UserParcelController::class, 'applyCoupon'])->name('parcels.apply_coupon');
Route::middleware('auth.customUser')->get('user/privacy-policy',[ProfileController::class, 'privacyPolicy']);
Route::middleware('auth.customUser')->get('user/terms-condition',[ProfileController::class, 'terms']);
Route::middleware('auth.customUser')->get('user/about-us',      [ProfileController::class, 'aboutUs']);

Route::middleware('auth.customUser')->post('user/rides', [RideController::class, 'createRide']);
Route::middleware('auth.customUser')->get('user/rides', [UserParcelController::class, 'allRides']);
Route::middleware('auth.custom')->post('/rides/{rideId}/accept', [RideController::class, 'acceptRide']);
Route::middleware('auth.customUser')->post('user/vehicle-option', [VehicleController::class, 'getVehicleOptions']);
Route::middleware('auth.customUser')->post('user/ride-status',  [UserParcelController::class, 'rideStatus']);
Route::middleware('auth.customUser')->get('user/cancel-reason',  [UserParcelController::class, 'cancelReason']);
Route::middleware('auth.customUser')->post('user/ride-payment-success',   [UserParcelController::class, 'ridePaymentSuccess'])->name('parcels.payment_success');

});
///////////////////////
