<?php

require __DIR__ . '/vendor/autoload.php';

use Ratchet\Client\WebSocket;
use Ratchet\Client\Connector;
use React\EventLoop\Factory;

// Create an event loop
$loop = Factory::create();

// Create a WebSocket connector
$connector = new Connector($loop);

// Connect to the WebSocket server
$connector('ws://192.99.16.162:6001')->then(
    function (WebSocket $conn) {
        echo "Connected to WebSocket server!\n";

        // Listen for messages
        $conn->on('message', function ($msg) use ($conn) {
            echo "Received: {$msg}\n";
        });

        // Listen for connection close
        $conn->on('close', function ($code = null, $reason = null) {
            echo "Connection closed ({$code} - {$reason})\n";
        });
    },
    function (\Exception $e) use ($loop) {
        echo "Could not connect: {$e->getMessage()}\n";
        $loop->stop();
    }
);

// Run the event loop
$loop->run();
